/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.spy;

import com.p6spy.engine.common.P6LogQuery;
import com.p6spy.engine.spy.P6Base;
import com.p6spy.engine.spy.P6Factory;
import com.p6spy.engine.spy.P6Statement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class P6ResultSet
extends P6Base
implements ResultSet {
    protected ResultSet passthru;
    protected P6Statement statement;
    protected String query;
    protected String preparedQuery;
    private Map resultMap = new TreeMap();
    private int currRow = -1;

    public P6ResultSet(P6Factory p6Factory, ResultSet resultSet, P6Statement p6Statement, String string, String string2) {
        this.setP6Factory(p6Factory);
        this.passthru = resultSet;
        this.statement = p6Statement;
        this.query = string2;
        this.preparedQuery = string;
    }

    public boolean next() throws SQLException {
        if (this.currRow > -1) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.resultMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string);
                stringBuffer.append(" = ");
                stringBuffer.append((String)this.resultMap.get(string));
                stringBuffer.append(", ");
            }
            int n = stringBuffer.length();
            if (n >= 2) {
                P6LogQuery.log("resultset", this.query, stringBuffer.substring(0, n - 2).toString());
            }
            this.resultMap.clear();
        }
        ++this.currRow;
        return this.passthru.next();
    }

    public int getRow() throws SQLException {
        return this.passthru.getRow();
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.passthru.getBytes(string);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.getBytes(this.passthru.getMetaData().getColumnName(n));
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.getBoolean(this.passthru.getMetaData().getColumnName(n));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.passthru.getBoolean(string);
    }

    public int getType() throws SQLException {
        return this.passthru.getType();
    }

    public long getLong(int n) throws SQLException {
        return this.getLong(this.passthru.getMetaData().getColumnName(n));
    }

    public long getLong(String string) throws SQLException {
        return this.passthru.getLong(string);
    }

    public boolean previous() throws SQLException {
        return this.passthru.previous();
    }

    public void close() throws SQLException {
        this.passthru.close();
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.passthru.getObject(string, map);
    }

    public Object getObject(int n) throws SQLException {
        return this.getObject(this.passthru.getMetaData().getColumnName(n));
    }

    public Object getObject(String string) throws SQLException {
        return this.passthru.getObject(string);
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.passthru.getObject(n, map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.passthru.getRef(string);
    }

    public Ref getRef(int n) throws SQLException {
        return this.getRef(this.passthru.getMetaData().getColumnName(n));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.passthru.getTime(n, calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.passthru.getTime(string, calendar);
    }

    public Time getTime(String string) throws SQLException {
        return this.passthru.getTime(string);
    }

    public Time getTime(int n) throws SQLException {
        return this.getTime(this.passthru.getMetaData().getColumnName(n));
    }

    public Date getDate(int n) throws SQLException {
        return this.getDate(this.passthru.getMetaData().getColumnName(n));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.passthru.getDate(string);
    }

    public Date getDate(String string) throws SQLException {
        return this.passthru.getDate(string);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.passthru.getDate(n, calendar);
    }

    public boolean wasNull() throws SQLException {
        return this.passthru.wasNull();
    }

    public String getString(String string) throws SQLException {
        String string2 = this.passthru.getString(string);
        this.resultMap.put(string, string2);
        return string2;
    }

    public String getString(int n) throws SQLException {
        return this.getString(this.passthru.getMetaData().getColumnName(n));
    }

    public byte getByte(String string) throws SQLException {
        return this.passthru.getByte(string);
    }

    public byte getByte(int n) throws SQLException {
        return this.getByte(this.passthru.getMetaData().getColumnName(n));
    }

    public short getShort(String string) throws SQLException {
        short s = this.passthru.getShort(string);
        this.resultMap.put(string, String.valueOf(s));
        return s;
    }

    public short getShort(int n) throws SQLException {
        return this.getShort(this.passthru.getMetaData().getColumnName(n));
    }

    public int getInt(int n) throws SQLException {
        return this.getInt(this.passthru.getMetaData().getColumnName(n));
    }

    public int getInt(String string) throws SQLException {
        int n = this.passthru.getInt(string);
        this.resultMap.put(string, String.valueOf(n));
        return n;
    }

    public float getFloat(String string) throws SQLException {
        return this.passthru.getFloat(string);
    }

    public float getFloat(int n) throws SQLException {
        return this.getFloat(this.passthru.getMetaData().getColumnName(n));
    }

    public double getDouble(int n) throws SQLException {
        return this.getDouble(this.passthru.getMetaData().getColumnName(n));
    }

    public double getDouble(String string) throws SQLException {
        return this.passthru.getDouble(string);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.passthru.getBigDecimal(string);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(this.passthru.getMetaData().getColumnName(n));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.passthru.getBigDecimal(n, n2);
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.passthru.getBigDecimal(string, n);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.passthru.getTimestamp(string);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.passthru.getTimestamp(string, calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(this.passthru.getMetaData().getColumnName(n));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.passthru.getTimestamp(n, calendar);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.passthru.getAsciiStream(string);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.getAsciiStream(this.passthru.getMetaData().getColumnName(n));
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.passthru.getUnicodeStream(n);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.passthru.getUnicodeStream(string);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.getBinaryStream(this.passthru.getMetaData().getColumnName(n));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.passthru.getBinaryStream(string);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.passthru.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.passthru.clearWarnings();
    }

    public String getCursorName() throws SQLException {
        return this.passthru.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getP6Factory().getResultSetMetaData(this.passthru.getMetaData());
    }

    public int findColumn(String string) throws SQLException {
        return this.passthru.findColumn(string);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.passthru.getCharacterStream(string);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return this.getCharacterStream(this.passthru.getMetaData().getColumnName(n));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.passthru.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        return this.passthru.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        return this.passthru.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.passthru.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.passthru.beforeFirst();
    }

    public void afterLast() throws SQLException {
        this.passthru.afterLast();
    }

    public boolean first() throws SQLException {
        return this.passthru.first();
    }

    public boolean last() throws SQLException {
        return this.passthru.last();
    }

    public boolean absolute(int n) throws SQLException {
        return this.passthru.absolute(n);
    }

    public boolean relative(int n) throws SQLException {
        return this.passthru.relative(n);
    }

    public void setFetchDirection(int n) throws SQLException {
        this.passthru.setFetchDirection(n);
    }

    public int getFetchDirection() throws SQLException {
        return this.passthru.getFetchDirection();
    }

    public void setFetchSize(int n) throws SQLException {
        this.passthru.setFetchSize(n);
    }

    public int getFetchSize() throws SQLException {
        return this.passthru.getFetchSize();
    }

    public int getConcurrency() throws SQLException {
        return this.passthru.getConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        return this.passthru.rowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        return this.passthru.rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        return this.passthru.rowDeleted();
    }

    public void updateNull(int n) throws SQLException {
        this.passthru.updateNull(n);
    }

    public void updateNull(String string) throws SQLException {
        this.passthru.updateNull(string);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.passthru.updateBoolean(n, bl);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.passthru.updateBoolean(string, bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.passthru.updateByte(string, by);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.passthru.updateByte(n, by);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.passthru.updateShort(n, s);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.passthru.updateShort(string, s);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.passthru.updateInt(n, n2);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.passthru.updateInt(string, n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.passthru.updateLong(n, l);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.passthru.updateLong(string, l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.passthru.updateFloat(string, f);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.passthru.updateFloat(n, f);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.passthru.updateDouble(n, d);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.passthru.updateDouble(string, d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.passthru.updateBigDecimal(string, bigDecimal);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.passthru.updateBigDecimal(n, bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.passthru.updateString(string, string2);
    }

    public void updateString(int n, String string) throws SQLException {
        this.passthru.updateString(n, string);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.passthru.updateBytes(n, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.passthru.updateBytes(string, byArray);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.passthru.updateDate(n, date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.passthru.updateDate(string, date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.passthru.updateTime(string, time);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.passthru.updateTime(n, time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.passthru.updateTimestamp(n, timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.passthru.updateTimestamp(string, timestamp);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.passthru.updateAsciiStream(n, inputStream, n2);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.passthru.updateAsciiStream(string, inputStream, n);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.passthru.updateBinaryStream(n, inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.passthru.updateBinaryStream(string, inputStream, n);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.passthru.updateCharacterStream(n, reader, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.passthru.updateCharacterStream(string, reader, n);
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.passthru.updateObject(n, object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.passthru.updateObject(n, object, n2);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.passthru.updateObject(string, object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.passthru.updateObject(string, object, n);
    }

    public void insertRow() throws SQLException {
        this.passthru.insertRow();
    }

    public void updateRow() throws SQLException {
        this.passthru.updateRow();
    }

    public void deleteRow() throws SQLException {
        this.passthru.deleteRow();
    }

    public void refreshRow() throws SQLException {
        this.passthru.refreshRow();
    }

    public void cancelRowUpdates() throws SQLException {
        this.passthru.cancelRowUpdates();
    }

    public void moveToInsertRow() throws SQLException {
        this.passthru.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.passthru.moveToCurrentRow();
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public Blob getBlob(int n) throws SQLException {
        return this.getBlob(this.passthru.getMetaData().getColumnName(n));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.passthru.getBlob(string);
    }

    public Clob getClob(String string) throws SQLException {
        return this.passthru.getClob(string);
    }

    public Clob getClob(int n) throws SQLException {
        return this.getClob(this.passthru.getMetaData().getColumnName(n));
    }

    public Array getArray(int n) throws SQLException {
        return this.getP6Factory().getArray(this.passthru.getArray(n), this.statement, this.preparedQuery, this.query);
    }

    public Array getArray(String string) throws SQLException {
        return this.getP6Factory().getArray(this.passthru.getArray(string), this.statement, this.preparedQuery, this.query);
    }

    public URL getURL(int n) throws SQLException {
        return this.passthru.getURL(n);
    }

    public URL getURL(String string) throws SQLException {
        return this.passthru.getURL(string);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.passthru.updateRef(n, ref);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.passthru.updateRef(string, ref);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.passthru.updateBlob(n, blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.passthru.updateBlob(string, blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.passthru.updateClob(n, clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.passthru.updateClob(string, clob);
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.passthru.updateArray(n, array);
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.passthru.updateArray(string, array);
    }

    public ResultSet getJDBC() {
        ResultSet resultSet = this.passthru instanceof P6ResultSet ? ((P6ResultSet)this.passthru).getJDBC() : this.passthru;
        return resultSet;
    }
}

