/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.spy;

import com.p6spy.engine.spy.P6Array;
import com.p6spy.engine.spy.P6Connection;
import com.p6spy.engine.spy.P6Factory;
import com.p6spy.engine.spy.P6Statement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class P6PreparedStatement
extends P6Statement
implements PreparedStatement {
    public static final int P6_MAX_FIELDS = 32;
    protected static int P6_GROW_MAX = 32;
    protected PreparedStatement prepStmtPassthru;
    protected String preparedQuery;
    protected Object[] values;
    protected boolean[] isString;

    public P6PreparedStatement(P6Factory factory, PreparedStatement statement, P6Connection conn, String query) {
        super(factory, statement, conn);
        this.prepStmtPassthru = statement;
        this.preparedQuery = query;
        this.initValues();
    }

    protected void initValues() {
        this.values = new Object[33];
        this.isString = new boolean[33];
    }

    public void addBatch() throws SQLException {
        this.prepStmtPassthru.addBatch();
    }

    public void clearParameters() throws SQLException {
        this.prepStmtPassthru.clearParameters();
    }

    public boolean execute() throws SQLException {
        return this.prepStmtPassthru.execute();
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet = this.prepStmtPassthru.executeQuery();
        return this.getP6Factory().getResultSet(resultSet, this, this.preparedQuery, this.getQueryFromPreparedStatement());
    }

    public int executeUpdate() throws SQLException {
        return this.prepStmtPassthru.executeUpdate();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.prepStmtPassthru.getMetaData();
    }

    public void setArray(int p0, Array p1) throws SQLException {
        this.setObjectAsString(p0, p1);
        if (p1 instanceof P6Array) {
            this.prepStmtPassthru.setArray(p0, ((P6Array)p1).passthru);
        } else {
            this.prepStmtPassthru.setArray(p0, p1);
        }
    }

    public void setAsciiStream(int p0, InputStream p1, int p2) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setAsciiStream(p0, p1, p2);
    }

    public void setBigDecimal(int p0, BigDecimal p1) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setBigDecimal(p0, p1);
    }

    public void setBinaryStream(int p0, InputStream p1, int p2) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setBinaryStream(p0, p1, p2);
    }

    public void setBlob(int p0, Blob p1) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setBlob(p0, p1);
    }

    public void setBoolean(int p0, boolean p1) throws SQLException {
        this.setObjectAsString(p0, new Boolean(p1));
        this.prepStmtPassthru.setBoolean(p0, p1);
    }

    public void setByte(int p0, byte p1) throws SQLException {
        this.setObjectAsString(p0, new Byte(p1));
        this.prepStmtPassthru.setByte(p0, p1);
    }

    public void setBytes(int p0, byte[] p1) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setBytes(p0, p1);
    }

    public void setCharacterStream(int p0, Reader p1, int p2) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setCharacterStream(p0, p1, p2);
    }

    public void setClob(int p0, Clob p1) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setClob(p0, p1);
    }

    public void setDate(int p0, Date p1) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setDate(p0, p1);
    }

    public void setDate(int p0, Date p1, Calendar p2) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setDate(p0, p1, p2);
    }

    public void setDouble(int p0, double p1) throws SQLException {
        this.setObjectAsInt(p0, new Double(p1));
        this.prepStmtPassthru.setDouble(p0, p1);
    }

    public void setFloat(int p0, float p1) throws SQLException {
        this.setObjectAsInt(p0, new Float(p1));
        this.prepStmtPassthru.setFloat(p0, p1);
    }

    public void setInt(int p0, int p1) throws SQLException {
        this.setObjectAsInt(p0, new Integer(p1));
        this.prepStmtPassthru.setInt(p0, p1);
    }

    public void setLong(int p0, long p1) throws SQLException {
        this.setObjectAsInt(p0, new Long(p1));
        this.prepStmtPassthru.setLong(p0, p1);
    }

    public void setNull(int p0, int p1, String p2) throws SQLException {
        this.setObjectAsString(p0, null);
        this.prepStmtPassthru.setNull(p0, p1, p2);
    }

    public void setNull(int p0, int p1) throws SQLException {
        this.setObjectAsString(p0, null);
        this.prepStmtPassthru.setNull(p0, p1);
    }

    public void setObject(int p0, Object p1, int p2, int p3) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setObject(p0, p1, p2, p3);
    }

    public void setObject(int p0, Object p1, int p2) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setObject(p0, p1, p2);
    }

    public void setObject(int p0, Object p1) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setObject(p0, p1);
    }

    public void setRef(int p0, Ref p1) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setRef(p0, p1);
    }

    public void setShort(int p0, short p1) throws SQLException {
        this.setObjectAsString(p0, new Short(p1));
        this.prepStmtPassthru.setShort(p0, p1);
    }

    public void setString(int p0, String p1) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setString(p0, p1);
    }

    public void setTime(int p0, Time p1, Calendar p2) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setTime(p0, p1, p2);
    }

    public void setTime(int p0, Time p1) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setTime(p0, p1);
    }

    public void setTimestamp(int p0, Timestamp p1, Calendar p2) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setTimestamp(p0, p1, p2);
    }

    public void setTimestamp(int p0, Timestamp p1) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setTimestamp(p0, p1);
    }

    public void setUnicodeStream(int p0, InputStream p1, int p2) throws SQLException {
        this.setObjectAsString(p0, p1);
        this.prepStmtPassthru.setUnicodeStream(p0, p1, p2);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getP6Factory().getResultSet(this.passthru.getResultSet(), this, this.preparedQuery, this.getQueryFromPreparedStatement());
    }

    public final String getQueryFromPreparedStatement() {
        int len = this.preparedQuery.length();
        StringBuffer t = new StringBuffer(len * 2);
        if (this.values != null) {
            int i = 1;
            int limit = 0;
            int base = 0;
            while ((limit = this.preparedQuery.indexOf(63, limit)) != -1) {
                if (this.isString[i]) {
                    t.append(this.preparedQuery.substring(base, limit));
                    t.append("'");
                    t.append(this.values[i]);
                    t.append("'");
                } else {
                    t.append(this.preparedQuery.substring(base, limit));
                    t.append(this.values[i]);
                }
                ++i;
                base = ++limit;
            }
            if (base < len) {
                t.append(this.preparedQuery.substring(base));
            }
        }
        return t.toString();
    }

    protected void growValues(int newMax) {
        int size = this.values.length;
        Object[] values_tmp = new Object[newMax + P6_GROW_MAX];
        boolean[] isString_tmp = new boolean[newMax + P6_GROW_MAX];
        System.arraycopy(this.values, 0, values_tmp, 0, size);
        this.values = values_tmp;
        System.arraycopy(this.isString, 0, isString_tmp, 0, size);
        this.isString = isString_tmp;
    }

    protected void setObjectAsString(int i, Object o) {
        if (this.values != null && i >= 0) {
            if (i >= this.values.length) {
                this.growValues(i);
            }
            this.values[i] = o == null ? "" : o.toString();
            this.isString[i] = true;
        }
    }

    protected void setObjectAsInt(int i, Object o) {
        if (this.values != null && i >= 0) {
            if (i >= this.values.length) {
                this.growValues(i);
            }
            this.values[i] = o == null ? "" : o.toString();
            this.isString[i] = false;
        }
    }

    public void setURL(int p0, URL p1) throws SQLException {
        this.prepStmtPassthru.setURL(p0, p1);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.prepStmtPassthru.getParameterMetaData();
    }

    public Statement getJDBC() {
        PreparedStatement wrapped = this.prepStmtPassthru instanceof P6Statement ? ((P6Statement)((Object)this.prepStmtPassthru)).getJDBC() : this.prepStmtPassthru;
        return wrapped;
    }
}

