/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.adapter;

import com.eg.jtm.JTMLog;
import com.eg.jtm.PropsManager;
import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.objectweb.asm.commons.AdviceAdapter;

public class EgSQLConnectionMethodAdviceAdapter
extends AdviceAdapter {
    private String methodName;
    private String className;
    private String description;
    private boolean isCommit;
    private boolean isClose;
    private boolean isRollback;
    private boolean isPrepareCall = false;
    private boolean isPreparedStatment = false;
    private int classFileVersion;
    private static final String INTERFACE_CONNECTION_COMMIT_METHOD_DESC = "()V";
    private static final String INTERFACE_CONNECTION_CLOSE_METHOD_DESC = "()V";
    private static final String INTERFACE_CONNECTION_ROLLBACK1_METHOD_DESC = "()V";
    private static final String INTERFACE_CONNECTION_ROLLBACK2_METHOD_DESC = "(Ljava/sql/Savepoint;)V";
    private static final String INTERFACE_CONNECTION_PREPARED_STAT1_METHOD_DESC = "(Ljava/lang/String;)Ljava/sql/PreparedStatement;";
    private static final String INTERFACE_CONNECTION_PREPARED_STAT2_METHOD_DESC = "(Ljava/lang/String;I)Ljava/sql/PreparedStatement;";
    private static final String INTERFACE_CONNECTION_PREPARED_STAT3_METHOD_DESC = "(Ljava/lang/String;II)Ljava/sql/PreparedStatement;";
    private static final String INTERFACE_CONNECTION_PREPARED_STAT4_METHOD_DESC = "(Ljava/lang/String;III)Ljava/sql/PreparedStatement;";
    private static final String INTERFACE_CONNECTION_PREPARED_STAT5_METHOD_DESC = "(Ljava/lang/String;[I)Ljava/sql/PreparedStatement;";
    private static final String INTERFACE_CONNECTION_PREPARED_STAT6_METHOD_DESC = "(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;";
    private static final String INTERFACE_CONNECTION_PREPARE_CALL1_METHOD_DESC = "(Ljava/lang/String;)Ljava/sql/CallableStatement;";
    private static final String INTERFACE_CONNECTION_PREPARE_CALL2_METHOD_DESC = "(Ljava/lang/String;II)Ljava/sql/CallableStatement;";
    private static final String INTERFACE_CONNECTION_PREPARE_CALL3_METHOD_DESC = "(Ljava/lang/String;III)Ljava/sql/CallableStatement;";
    private int okFlag = this.newLocal(Type.BOOLEAN_TYPE);
    Label startFinally = new Label();

    public EgSQLConnectionMethodAdviceAdapter(int access, MethodVisitor mv, String methodName, String description, String className, int classFileVersion) {
        super(327680, mv, access, methodName, description);
        this.className = className;
        this.methodName = methodName;
        this.description = description;
        this.classFileVersion = classFileVersion;
        this.isClose = false;
        this.isCommit = false;
        this.isRollback = false;
        if (this.methodName.equals("commit") && this.description.equals("()V")) {
            this.isCommit = true;
        } else if (this.methodName.equals("close") && this.description.equals("()V")) {
            this.isClose = true;
        } else if (methodName.equals("rollback")) {
            if (this.description.equals("()V") || this.description.equals(INTERFACE_CONNECTION_ROLLBACK2_METHOD_DESC)) {
                this.isRollback = true;
            }
        } else if (methodName.equals("prepareCall")) {
            if (this.description.equals(INTERFACE_CONNECTION_PREPARE_CALL1_METHOD_DESC) || this.description.equals(INTERFACE_CONNECTION_PREPARE_CALL2_METHOD_DESC) || this.description.equals(INTERFACE_CONNECTION_PREPARE_CALL3_METHOD_DESC)) {
                this.isPrepareCall = true;
            }
        } else if (methodName.equals("prepareStatement") && (this.description.equals(INTERFACE_CONNECTION_PREPARED_STAT1_METHOD_DESC) || this.description.equals(INTERFACE_CONNECTION_PREPARED_STAT2_METHOD_DESC) || this.description.equals(INTERFACE_CONNECTION_PREPARED_STAT3_METHOD_DESC) || this.description.equals(INTERFACE_CONNECTION_PREPARED_STAT4_METHOD_DESC) || this.description.equals(INTERFACE_CONNECTION_PREPARED_STAT5_METHOD_DESC) || this.description.equals(INTERFACE_CONNECTION_PREPARED_STAT6_METHOD_DESC))) {
            this.isPreparedStatment = true;
        }
        if (PropsManager.jtmDebugEnabled) {
            JTMLog.debugLogger.info(" [SQL-Connection MethodAdviceAdapter] :" + className + " \t " + methodName + " \t  " + description);
        }
    }

    public void visitCode() {
        super.visitCode();
        this.mv.visitLabel(this.startFinally);
    }

    protected void onMethodEnter() {
        if (this.isCommit || this.isClose || this.isRollback) {
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(54, this.okFlag);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "jdbcCommitCloseRollbackMethodBegin", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", false);
            this.mv.visitVarInsn(54, this.okFlag);
        } else if (this.isPrepareCall || this.isPreparedStatment) {
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(54, this.okFlag);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "jdbcPrepareCallPreparedStatmentMethodBegin", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", false);
            this.mv.visitVarInsn(54, this.okFlag);
        }
    }

    protected void onMethodExit(int opcode) {
        if (opcode != 191) {
            this.onFinally(opcode);
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.onFinally(191);
        this.mv.visitInsn(191);
        super.visitMaxs(maxStack, maxLocals);
    }

    private void onFinally(int opcode) {
        if (this.isCommit || this.isClose || this.isRollback) {
            if (opcode == 191) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methodName);
                this.mv.visitLdcInsn(this.description);
                this.mv.visitVarInsn(21, this.okFlag);
                this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "recordSQLException", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", false);
            }
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitVarInsn(21, this.okFlag);
            this.mv.visitLdcInsn(opcode);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "jdbcCommitCloseRollbackMethodEnd", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZI)V", false);
        } else if (this.isPrepareCall || this.isPreparedStatment) {
            if (opcode == 191) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methodName);
                this.mv.visitLdcInsn(this.description);
                this.mv.visitVarInsn(21, this.okFlag);
                this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "recordSQLException", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", false);
            }
            this.mv.visitInsn(89);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitVarInsn(21, this.okFlag);
            this.mv.visitLdcInsn(opcode);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "jdbcPrepareCallPreparedStatmentMethodEnd", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZI)V", false);
        }
    }
}

