/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent;

import com.eg.agent.EgClassFileTransformer;
import com.eg.jtm.JTMLog;
import com.eg.jtm.PropsManager;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Hashtable;

public class LazyInstrumentationThread
extends Thread {
    private Instrumentation instrumentation;
    private ArrayList lazyList = null;
    private boolean isRetransSupported;

    public LazyInstrumentationThread(Instrumentation instrumentation, boolean isRetransSupported, ArrayList lazyList) {
        this.instrumentation = instrumentation;
        this.lazyList = lazyList;
        this.isRetransSupported = isRetransSupported;
        this.setName("eG JTM Lazy Retransform");
        this.setDaemon(true);
    }

    public void run() {
        block16: {
            if (this.lazyList == null || this.lazyList.size() == 0) {
                return;
            }
            if (this.isRetransSupported) {
                boolean checkExcludeFlag = false;
                JTMLog.logger.info("PropsManager.lazyTimeInseconds :" + PropsManager.lazyTimeInseconds);
                try {
                    long sleepTime = PropsManager.lazyTimeInseconds * 1000;
                    Thread.sleep(sleepTime);
                    JTMLog.debugLogger.info("R  E  T  R  A  N  S  F  O  R  M  Starting now !!!");
                    JTMLog.debugLogger.info("lazyList :" + this.lazyList);
                    Hashtable<String, Category> categoryTable = new Hashtable<String, Category>();
                    int k = 0;
                    while (k < this.lazyList.size()) {
                        String thisName = (String)this.lazyList.get(k);
                        int length = thisName.length();
                        boolean firstSlash = false;
                        boolean lastSlash = false;
                        Category category = Category.D;
                        char firstChar = thisName.charAt(0);
                        char lastChar = thisName.charAt(length - 1);
                        if (firstChar == '/') {
                            firstSlash = true;
                        }
                        if (lastChar == '/') {
                            lastSlash = true;
                        }
                        if ((category = firstSlash && lastSlash ? Category.A : (firstSlash ? Category.B : (lastSlash ? Category.C : Category.D))) != null) {
                            categoryTable.put(thisName, category);
                        }
                        ++k;
                    }
                    Class[] classes = this.instrumentation.getAllLoadedClasses();
                    ArrayList<Class> classList = new ArrayList<Class>();
                    int i = 0;
                    while (i < classes.length) {
                        if (this.instrumentation.isModifiableClass(classes[i])) {
                            String className = classes[i].getName();
                            boolean needToAdd = false;
                            needToAdd = this.isRetransformRequired(className, categoryTable);
                            if (needToAdd) {
                                JTMLog.debugLogger.info(" className  ==>" + className);
                                classList.add(classes[i]);
                            }
                        }
                        ++i;
                    }
                    JTMLog.debugLogger.info(" No.Of Classes :" + classList.size() + "  isRetransSupported :" + this.isRetransSupported);
                    JTMLog.debugLogger.info(" Retransform the Following classes only :" + classList);
                    if (classList.size() <= 0) break block16;
                    EgClassFileTransformer lazyTransformer = new EgClassFileTransformer(checkExcludeFlag);
                    this.instrumentation.addTransformer(lazyTransformer, true);
                    int success = 0;
                    ArrayList<String> failList = new ArrayList<String>();
                    int k2 = 0;
                    while (k2 < classList.size()) {
                        Class[] workaround = new Class[]{(Class)classList.get(k2)};
                        try {
                            Thread.sleep(20L);
                            JTMLog.debugLogger.info("Retranforming the Class - " + workaround[0].getName());
                            this.instrumentation.retransformClasses(workaround);
                            ++success;
                        }
                        catch (Throwable t) {
                            JTMLog.debugLogger.error("Error while performing retransformation", t);
                            failList.add(workaround[0].getName());
                        }
                        ++k2;
                    }
                    this.instrumentation.removeTransformer(lazyTransformer);
                    JTMLog.debugLogger.info("Transformer is successfully removed!");
                    if (success > 0) {
                        JTMLog.debugLogger.info("Total no.of classes retransformed successfully :" + success);
                    }
                    if (failList.size() > 0) {
                        JTMLog.debugLogger.info("Total no.of failed retransformed classes :" + failList.size());
                        JTMLog.debugLogger.info("List of failed classes :" + failList);
                    }
                }
                catch (Exception e) {
                    JTMLog.debugLogger.error("Error in LazyInstrumentationThread", e);
                }
            }
        }
    }

    private boolean isRetransformRequired(String className, Hashtable catTable) {
        boolean result = false;
        if (className == null) {
            return result;
        }
        String fullyQualifiedClassName = className.replace('.', '/');
        boolean presentInLazyList = false;
        Category matchedCategory = null;
        int k = 0;
        while (k < this.lazyList.size()) {
            String lazyName = (String)this.lazyList.get(k);
            Category category = (Category)((Object)catTable.get(lazyName));
            switch (category) {
                case A: {
                    if (fullyQualifiedClassName.indexOf(lazyName) <= 0) break;
                    presentInLazyList = true;
                    matchedCategory = category;
                    break;
                }
                case B: {
                    if (!fullyQualifiedClassName.endsWith(lazyName)) break;
                    presentInLazyList = true;
                    matchedCategory = category;
                    break;
                }
                case C: {
                    if (!fullyQualifiedClassName.startsWith(lazyName)) break;
                    presentInLazyList = true;
                    matchedCategory = category;
                    break;
                }
                case D: {
                    if (!fullyQualifiedClassName.equals(lazyName)) break;
                    presentInLazyList = true;
                    matchedCategory = category;
                }
            }
            if (presentInLazyList) break;
            ++k;
        }
        if (presentInLazyList) {
            result = true;
            if (matchedCategory == Category.D) {
                boolean isPresent = this.checkClasses(fullyQualifiedClassName);
                if (isPresent) {
                    result = false;
                }
            } else {
                boolean isPresentInPattern;
                boolean isPresentInPackage;
                boolean isPresentInClass = this.checkClasses(fullyQualifiedClassName);
                if (isPresentInClass) {
                    result = false;
                }
                if (result && (isPresentInPackage = this.checkPackages(fullyQualifiedClassName))) {
                    result = false;
                }
                if (result && (isPresentInPattern = this.checkPatterns(fullyQualifiedClassName))) {
                    result = false;
                }
            }
        }
        return result;
    }

    private boolean checkPatterns(String className) {
        boolean isPresent = false;
        ArrayList excludeList = EgClassFileTransformer.getExcludePatternList();
        int len = excludeList.size();
        int k = 0;
        while (k < len) {
            String pkgname = (String)excludeList.get(k);
            if (className.startsWith(pkgname) || className.indexOf("/" + pkgname) > 0) {
                isPresent = true;
                break;
            }
            ++k;
        }
        return isPresent;
    }

    private boolean checkPackages(String className) {
        boolean isPresent = false;
        ArrayList excludeList = EgClassFileTransformer.getExcludePackageList();
        int i = 0;
        while (i < excludeList.size()) {
            String exPackageName = (String)excludeList.get(i);
            if (className.startsWith(exPackageName)) {
                isPresent = true;
                break;
            }
            ++i;
        }
        return isPresent;
    }

    private boolean checkClasses(String className) {
        boolean isPresent = false;
        if (EgClassFileTransformer.GetExcludeClassList().contains(className)) {
            isPresent = true;
        }
        return isPresent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Category {
        A,
        B,
        C,
        D;

    }
}

