/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.jmx.connector.oc4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import oracle.oc4j.admin.jmx.client.ClientMBeanServerProxyFactory;
import oracle.oc4j.admin.jmx.client.Oc4jDomainFactory;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.jmx.connector.JMXConnector;

public class Connector
implements JMXConnector {
    private static final String DEFAULT_PROTOCOL = "jmx";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 23791;

    public Hashtable getInitialContextProperties(Hashtable contextProps) {
        if (!contextProps.containsKey("java.naming.provider.url")) {
            try {
                contextProps.put("java.naming.provider.url", "jmx://" + InetAddress.getLocalHost().getHostName() + ":" + 23791);
            }
            catch (UnknownHostException e) {
                contextProps.put("java.naming.provider.url", "jmx://localhost:23791");
            }
        }
        return contextProps;
    }

    public Hashtable getInitialContextProperties(String providerurl, String user, String password) {
        Hashtable props = this.getInitialContextProperties(new Hashtable());
        if (providerurl != null) {
            props.put("java.naming.provider.url", providerurl);
        }
        if (user != null) {
            props.put("java.naming.security.principal", user);
        }
        if (password != null) {
            props.put("java.naming.security.credentials", password);
        }
        return props;
    }

    public MBeanServer getMBeanServer(Hashtable contextProps, String jndiName) throws BuildException {
        String url = (String)contextProps.get("java.naming.provider.url");
        if (url == null) {
            throw new IllegalArgumentException("Missing JMX url under key: java.naming.provider.url");
        }
        String user = (String)contextProps.get("java.naming.security.principal");
        if (user == null) {
            throw new IllegalArgumentException("Missing JMX user under key: java.naming.security.principal");
        }
        String password = (String)contextProps.get("java.naming.security.credentials");
        if (password == null) {
            throw new IllegalArgumentException("Missing JMX user's credentials under key: java.naming.security.credentials");
        }
        Domain domain = Oc4jDomainFactory.getDomainFromJmx4antUrl(url, user, password);
        oracle.oc4j.admin.jmx.client.Connector connection = ClientMBeanServerProxyFactory.getMBeanServer(domain);
        return new MBeanServerConnectionToMBeanServerAdaptor(connection);
    }

    public String getActiveDomain(MBeanServer mbserver) {
        return mbserver.getDefaultDomain();
    }

    public ObjectName createMBean(String type, ObjectName objectName, MBeanServer mbserver) throws MBeanRegistrationException {
        throw new UnsupportedOperationException("This feature is not supported by OC4J's JMX");
    }

    public class MBeanServerConnectionToMBeanServerAdaptor
    implements MBeanServer {
        private MBeanServerConnection mbeanServer_ = null;

        public MBeanServerConnectionToMBeanServerAdaptor(MBeanServerConnection server) {
            this.mbeanServer_ = server;
        }

        public final ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }

        public final ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }

        public final ClassLoaderRepository getClassLoaderRepository() {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }

        public final Object instantiate(String className) throws ReflectionException, MBeanException {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }

        public final Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }

        public final Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }

        public final Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }

        public final void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
            try {
                this.mbeanServer_.addNotificationListener(name, listener, filter, handback);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
            try {
                this.mbeanServer_.addNotificationListener(name, listener, filter, handback);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
            try {
                this.mbeanServer_.removeNotificationListener(name, listener);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
            try {
                this.mbeanServer_.removeNotificationListener(name, listener);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
            try {
                this.mbeanServer_.removeNotificationListener(name, listener, filter, handback);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
            try {
                this.mbeanServer_.removeNotificationListener(name, listener, filter, handback);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }

        public final ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }

        public final ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }

        public final ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }

        public final ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }

        public final String[] getDomains() {
            try {
                return this.mbeanServer_.getDomains();
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
            try {
                this.mbeanServer_.unregisterMBean(name);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
            try {
                return this.mbeanServer_.getObjectInstance(name);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final Set queryMBeans(ObjectName name, QueryExp query) {
            try {
                return this.mbeanServer_.queryMBeans(name, query);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final Set queryNames(ObjectName name, QueryExp query) {
            try {
                return this.mbeanServer_.queryNames(name, query);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final boolean isRegistered(ObjectName name) {
            try {
                return this.mbeanServer_.isRegistered(name);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final Integer getMBeanCount() {
            try {
                return this.mbeanServer_.getMBeanCount();
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
            try {
                return this.mbeanServer_.getAttribute(name, attribute);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
            try {
                return this.mbeanServer_.getAttributes(name, attributes);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            try {
                this.mbeanServer_.setAttribute(name, attribute);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
            try {
                return this.mbeanServer_.setAttributes(name, attributes);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
            try {
                return this.mbeanServer_.invoke(name, operationName, params, signature);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final String getDefaultDomain() {
            try {
                return this.mbeanServer_.getDefaultDomain();
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
            try {
                return this.mbeanServer_.getMBeanInfo(name);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
            try {
                return this.mbeanServer_.isInstanceOf(name, className);
            }
            catch (IOException e) {
                throw new JMXRuntimeException(e);
            }
        }

        public final ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }

        public final ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }

        public final ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
            throw new UnsupportedOperationException("This part of the API is not supported");
        }
    }
}

