/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.shared.statistic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Locale;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.EJBStats;
import javax.management.j2ee.statistics.Statistic;
import oracle.dms.spy.Spy;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.shared.statistic.CountStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.StatsLocalizationHelper;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSMetric;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSRangeStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatsImpl;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSTimeStatistic;

public class EJBStatsImpl
extends DMSStatsImpl
implements EJBStats {
    static final long serialVersionUID = 8717594819939208414L;
    private String applicationName_ = null;
    private String moduleName_ = null;
    private String ejbName_ = null;
    private transient String metricPath_ = null;
    private transient long createCount_ = 0L;
    private transient long removeCount_ = 0L;
    protected transient StatsLocalizationHelper statsLocalizationHelper_ = null;

    public EJBStatsImpl(String applicationName, String moduleName, String ejbName, Locale loc) {
        this.statsLocalizationHelper_ = new StatsLocalizationHelper(loc);
        this.applicationName_ = applicationName;
        this.moduleName_ = moduleName;
        this.ejbName_ = ejbName;
        this.metricPath_ = "@oc4j@" + this.applicationName_ + "@EJBs@" + this.moduleName_ + "@" + this.ejbName_ + "@";
        Statistic[] jsr77Stats = this.getStats();
        this.addJSR77Stats(jsr77Stats);
        this.initStats();
    }

    public CountStatistic getCreateCount() {
        return (CountStatistic)this.getStatistic("CreateCount");
    }

    public CountStatistic getRemoveCount() {
        return (CountStatistic)this.getStatistic("RemoveCount");
    }

    private final String[] getDMSMethodsName() {
        try {
            Class<?> cl = Class.forName("oracle.oc4j.admin.management.util.DMSHelper");
            Class[] params = new Class[]{Class.forName("java.lang.String")};
            Method method = cl.getDeclaredMethod("getDMSChildrenName", params);
            Object[] args = new Object[]{this.metricPath_};
            return (String[])method.invoke(null, args);
        }
        catch (ClassNotFoundException e) {
            throw new JMXRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new JMXRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new JMXRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new JMXRuntimeException(e);
        }
    }

    protected Statistic[] getStats() {
        DMSStatsImpl stats = new DMSStatsImpl();
        String commonMetricPath = this.getCommonMetricPath();
        String[] methodNames = this.getDMSMethodsName();
        String[] statNames = new String[methodNames.length * 4];
        DMSStatistic[] dmsStats = new DMSStatistic[statNames.length];
        long createCount = 0L;
        for (int i = 0; i < methodNames.length; ++i) {
            Object val;
            statNames[i * 4] = methodNames[i] + "ClientTime";
            statNames[i * 4 + 1] = methodNames[i] + "WrapperTime";
            statNames[i * 4 + 2] = methodNames[i] + "ClientActive";
            statNames[i * 4 + 3] = methodNames[i] + "WrapperActive";
            dmsStats[i * 4] = new DMSTimeStatistic(new DMSMetric(this.metricPath_ + methodNames[i] + "@" + "client", statNames[i * 4], this.statsLocalizationHelper_.getLocalizedMessage("stats_ejbstatsimpl_method", "client", methodNames[i]), "MILLISECONDS"));
            dmsStats[i * 4 + 1] = new DMSTimeStatistic(new DMSMetric(this.metricPath_ + methodNames[i] + "@" + "wrapper", statNames[i * 4 + 1], this.statsLocalizationHelper_.getLocalizedMessage("stats_ejbstatsimpl_method", "wrapper", methodNames[i]), "MILLISECONDS"));
            dmsStats[i * 4 + 2] = new DMSRangeStatistic(new DMSMetric(this.metricPath_ + methodNames[i] + "@" + "client", 64, statNames[i * 4 + 2], this.statsLocalizationHelper_.getLocalizedMessage("stats_ejbstatsimpl_active_req", methodNames[i]), "REQUESTS", null, null, null, null));
            dmsStats[i * 4 + 3] = new DMSRangeStatistic(new DMSMetric(this.metricPath_ + methodNames[i] + "@" + "wrapper", 64, statNames[i * 4 + 3], this.statsLocalizationHelper_.getLocalizedMessage("stats_ejbstatsimpl_active_req", methodNames[i]), "REQUESTS", null, null, null, null));
            if (methodNames[i].startsWith("ejbCreate") && (val = Spy.getMetricValue((String)(this.metricPath_ + methodNames[i] + "@" + "client" + ".completed"))) != null && val instanceof Integer) {
                createCount += (long)((Integer)val).intValue();
            }
            if (!methodNames[i].startsWith("ejbRemove") || (val = Spy.getMetricValue((String)(this.metricPath_ + methodNames[i] + "@" + "client" + ".completed"))) == null || !(val instanceof Integer)) continue;
            this.removeCount_ = ((Integer)val).intValue();
        }
        this.createCount_ = createCount;
        stats.addDMSStats(dmsStats);
        long lastSampleTime = new Date().getTime();
        long upTime = 0L;
        Object val = Spy.getMetricValue((String)"/JVM/upTime.value");
        if (val != null && val instanceof Long) {
            upTime = (Long)val;
        }
        long startTime = lastSampleTime - upTime;
        Statistic[] jsr77Stats = new Statistic[]{new CountStatisticImpl("CreateCount", "COUNT", this.statsLocalizationHelper_.getLocalizedMessage("stats_ejbstatsimpl_create"), startTime, lastSampleTime, this.createCount_), new CountStatisticImpl("RemoveCount", "COUNT", this.statsLocalizationHelper_.getLocalizedMessage("stats_ejbstatsimpl_remove"), startTime, lastSampleTime, this.removeCount_)};
        stats.addJSR77Stats(jsr77Stats);
        stats.initStats();
        return stats.getStatistics();
    }

    protected String getCommonMetricPath() {
        return this.metricPath_;
    }
}

