/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.shared.util;

import java.lang.reflect.Method;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;

public class ObjectNameUtil {
    private ObjectNameUtil() {
    }

    public static String quote(String s) {
        Class<?> cl = null;
        try {
            cl = Class.forName("javax.management.ObjectName");
        }
        catch (ClassNotFoundException e) {
            throw new JMXRuntimeException(e);
        }
        Class[] paramTypes = new Class[]{String.class};
        Method mtd = null;
        try {
            mtd = cl.getDeclaredMethod("quote", paramTypes);
        }
        catch (NoSuchMethodException e) {
            return s;
        }
        catch (SecurityException e) {
            throw new JMXRuntimeException(e);
        }
        Object[] params = new Object[]{s};
        try {
            return (String)mtd.invoke(null, params);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public static String unquote(String s) {
        Class<?> cl = null;
        try {
            cl = Class.forName("javax.management.ObjectName");
        }
        catch (ClassNotFoundException e) {
            throw new JMXRuntimeException(e);
        }
        Class[] paramTypes = new Class[]{String.class};
        Method mtd = null;
        try {
            mtd = cl.getDeclaredMethod("unquote", paramTypes);
        }
        catch (NoSuchMethodException e) {
            return s;
        }
        catch (SecurityException e) {
            throw new JMXRuntimeException(e);
        }
        Object[] params = new Object[]{s};
        try {
            return (String)mtd.invoke(null, params);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public static boolean isQuoted(String name) {
        int len = name.length();
        return len >= 2 && name.charAt(0) == '\"' && name.charAt(len - 1) == '\"';
    }
}

