/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.shared;

import com.evermind.server.cluster.ServerIdentification;
import com.evermind.util.OpmnHelper;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import javax.management.remote.JMXServiceURL;
import oracle.oc4j.admin.jmx.shared.ClusterDomain;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.Oc4jRmiApplicationLevelDomain;

public class Oc4jOpmnRmiApplicationLevelDomain
extends Oc4jRmiApplicationLevelDomain
implements ClusterDomain {
    static final long serialVersionUID = -2236478811946945075L;
    private String opmnHost_ = null;
    private int opmnPort_ = 6003;
    private String oc4jInstance_ = null;

    public Oc4jOpmnRmiApplicationLevelDomain(String opmnHost, int opmnPort, String oc4jInstance, String login, String pwd, String appName) {
        super(opmnHost, opmnPort, login, pwd, appName);
        this.opmnHost_ = opmnHost;
        this.opmnPort_ = opmnPort;
        this.oc4jInstance_ = oc4jInstance;
    }

    public Oc4jOpmnRmiApplicationLevelDomain(String opmnHost, String oc4jInstance, String login, String pwd, String appName) {
        super(opmnHost, 6003, login, pwd, appName);
        this.opmnHost_ = opmnHost;
        this.oc4jInstance_ = oc4jInstance;
    }

    public Oc4jOpmnRmiApplicationLevelDomain(String opmnHost, int opmnPort, String oc4jInstance, String appName) {
        super(opmnHost, opmnPort, appName);
        this.opmnHost_ = opmnHost;
        this.opmnPort_ = opmnPort;
        this.oc4jInstance_ = oc4jInstance;
    }

    public Oc4jOpmnRmiApplicationLevelDomain(String domain) {
        super(domain.substring(domain.indexOf(43) + 1));
        StringTokenizer st = new StringTokenizer(domain, "+");
        String opmnst = st.nextToken();
        StringTokenizer stb = new StringTokenizer(opmnst, "-");
        st.nextToken();
        this.oc4jInstance_ = st.nextToken();
    }

    public Oc4jOpmnRmiApplicationLevelDomain(String domain, String login, String pwd) {
        super(domain.substring(domain.indexOf(43) + 1), login, pwd);
        StringTokenizer st = new StringTokenizer(domain, "+");
        String opmnst = st.nextToken();
        StringTokenizer stb = new StringTokenizer(opmnst, "-");
        st.nextToken();
        this.oc4jInstance_ = st.nextToken();
    }

    public String toString() {
        return "opmn-" + this.oc4jInstance_ + "+" + super.toString();
    }

    protected String getSecureDomain() {
        return "opmn-" + this.oc4jInstance_ + "+" + super.getSecureDomain();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Oc4jOpmnRmiApplicationLevelDomain) {
            return super.equals(obj);
        }
        return false;
    }

    public final String getHost() {
        String wireProtocol = (String)this.getProperty("com.oracle.jmx.remote.oc4j.wireprotocol");
        String connType = null;
        connType = "ormis".equals(wireProtocol) ? "rmis" : (this.getHttpTunnelingPath() == null ? "rmi" : "ajp");
        ServerIdentification[] oc4js = OpmnHelper.getOc4jServers((String)this.opmnHost_, (int)this.opmnPort_, (String)this.oc4jInstance_, (String)connType, (String)this.getApplication());
        if (oc4js == null || oc4js.length == 0) {
            throw new RuntimeException("OPMN was unable to get OC4J RMI host for instance: " + this.oc4jInstance_);
        }
        return oc4js[0].getAddress();
    }

    public final int getPort() {
        String wireProtocol = (String)this.getProperty("com.oracle.jmx.remote.oc4j.wireprotocol");
        String connType = null;
        connType = "ormis".equals(wireProtocol) ? "rmis" : (this.getHttpTunnelingPath() == null ? "rmi" : "ajp");
        ServerIdentification[] oc4js = OpmnHelper.getOc4jServers((String)this.opmnHost_, (int)this.opmnPort_, (String)this.oc4jInstance_, (String)connType, (String)this.getApplication());
        if (oc4js == null || oc4js.length == 0) {
            throw new RuntimeException("OPMN was unable to get OC4J RMI port for instance: " + this.oc4jInstance_);
        }
        return oc4js[0].getPort();
    }

    public JMXServiceURL getJMXServiceURL() throws MalformedURLException {
        String wireProtocol = (String)this.getProperty("com.oracle.jmx.remote.oc4j.wireprotocol");
        String url = "service:jmx:";
        url = "ormis".equals(wireProtocol) ? url + "ormis" : url + "ormi";
        url = url + ":///opmn://" + this.opmnHost_ + ":" + this.opmnPort_ + "/" + this.oc4jInstance_ + "/" + this.getApplication();
        return new JMXServiceURL(url);
    }

    public int[] getPorts() {
        String wireProtocol = (String)this.getProperty("com.oracle.jmx.remote.oc4j.wireprotocol");
        String connType = null;
        connType = "ormis".equals(wireProtocol) ? "rmis" : (this.getHttpTunnelingPath() == null ? "rmi" : "ajp");
        ServerIdentification[] oc4js = OpmnHelper.getOc4jServers((String)this.opmnHost_, (int)this.opmnPort_, (String)this.oc4jInstance_, (String)connType, (String)this.getApplication());
        if (oc4js == null || oc4js.length == 0) {
            throw new RuntimeException("OPMN was unable to get OC4J RMI ports for instance: " + this.oc4jInstance_);
        }
        int[] res = new int[oc4js.length];
        for (int i = 0; i < oc4js.length; ++i) {
            res[i] = oc4js[i].getPort();
        }
        return res;
    }

    public String getOPMNHost() {
        return this.opmnHost_;
    }

    public int getOPMNPort() {
        return this.opmnPort_;
    }

    public String getOC4JComponentClusterName() {
        return this.oc4jInstance_;
    }

    public Domain[] getSynchronizationDomains() {
        return this.getSynchronizationDomains(-1);
    }

    public Domain[] getSynchronizationDomains(int mainPort) {
        int[] allPorts = this.getPorts();
        if (allPorts == null || allPorts.length == 1) {
            return null;
        }
        boolean found = false;
        for (int i = 0; i < allPorts.length; ++i) {
            if (allPorts[i] != mainPort) continue;
            found = true;
        }
        int[] syncPorts = null;
        if (found) {
            syncPorts = new int[allPorts.length - 1];
            int j = 0;
            for (int i = 0; i < allPorts.length; ++i) {
                if (allPorts[i] == mainPort) continue;
                syncPorts[j++] = allPorts[i];
            }
        } else {
            syncPorts = allPorts;
        }
        Domain[] res = new Domain[syncPorts.length];
        String wireProtocol = (String)this.getProperty("com.oracle.jmx.remote.oc4j.wireprotocol");
        for (int i = 0; i < syncPorts.length; ++i) {
            res[i] = this.login_ != null && this.sagar_ != null ? new Oc4jRmiApplicationLevelDomain(this.opmnHost_, syncPorts[i], this.login_, this.sagar_, this.getApplication()) : new Oc4jRmiApplicationLevelDomain(this.opmnHost_, syncPorts[i], this.getApplication());
            if (wireProtocol != null) {
                res[i].addProperty("com.oracle.jmx.remote.oc4j.wireprotocol", wireProtocol);
            }
            if (this.getHttpTunnelingPath() == null) continue;
            res[i].setHttpTunnelingPath(this.getHttpTunnelingPath());
        }
        return res;
    }
}

