/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.shared;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;

public abstract class DomainBase
implements Domain {
    static final long serialVersionUID = 1257690655087394418L;
    public static final int DEFAULT_OPMN_PORT = 6003;
    private Locale loc_ = null;
    private boolean isCachingOn_ = true;
    static long uniqueId_ = 0L;
    private static final String domainSeparator = "-";
    private String appName_ = "default";
    private int port_ = 0;
    private String host_ = null;
    protected transient String login_ = null;
    protected transient String sagar_ = null;
    private String domain_ = null;
    private transient String securedomain_ = null;
    private String httpTunnelingPath_ = null;
    private Map extraProperties_ = new HashMap();

    protected DomainBase(String host, int port, String login, String pwd) {
        this.port_ = port;
        this.host_ = host;
        this.domain_ = this.getDomainPrefix() + domainSeparator + this.host_ + domainSeparator + Integer.toString(this.port_) + domainSeparator + this.appName_;
        this.login_ = login;
        this.sagar_ = pwd;
        this.securedomain_ = this.domain_ + domainSeparator + login + domainSeparator + pwd;
    }

    protected DomainBase(String host, int port, String login, String pwd, String appName) {
        this.port_ = port;
        this.host_ = host;
        this.appName_ = appName;
        this.domain_ = this.getDomainPrefix() + domainSeparator + this.host_ + domainSeparator + Integer.toString(this.port_) + domainSeparator + this.appName_;
        this.login_ = login;
        this.sagar_ = pwd;
        this.securedomain_ = this.domain_ + domainSeparator + login + domainSeparator + pwd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DomainBase(String host, int port) {
        long uniqueId;
        this.port_ = port;
        this.host_ = host;
        this.domain_ = this.getDomainPrefix() + domainSeparator + this.host_ + domainSeparator + Integer.toString(this.port_) + domainSeparator + this.appName_;
        Class clazz = Domain.class;
        synchronized (clazz) {
            uniqueId = uniqueId_++;
        }
        this.securedomain_ = this.domain_ + domainSeparator + uniqueId + domainSeparator + uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DomainBase(String host, int port, String appName) {
        long uniqueId;
        this.port_ = port;
        this.host_ = host;
        this.appName_ = appName;
        this.domain_ = this.getDomainPrefix() + domainSeparator + this.host_ + domainSeparator + Integer.toString(this.port_) + domainSeparator + this.appName_;
        Class clazz = Domain.class;
        synchronized (clazz) {
            uniqueId = uniqueId_++;
        }
        this.securedomain_ = this.domain_ + domainSeparator + uniqueId + domainSeparator + uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DomainBase(String domain) {
        long uniqueId;
        StringTokenizer st = new StringTokenizer(domain, domainSeparator);
        st.nextToken();
        this.host_ = st.nextToken();
        this.port_ = Integer.parseInt(st.nextToken());
        this.appName_ = st.nextToken();
        this.domain_ = this.getDomainPrefix() + domainSeparator + this.host_ + domainSeparator + Integer.toString(this.port_) + domainSeparator + this.appName_;
        Class clazz = Domain.class;
        synchronized (clazz) {
            uniqueId = uniqueId_++;
        }
        this.securedomain_ = this.domain_ + domainSeparator + uniqueId;
    }

    protected DomainBase(String domain, String login, String pwd) {
        StringTokenizer st = new StringTokenizer(domain, domainSeparator);
        st.nextToken();
        this.host_ = st.nextToken();
        this.port_ = Integer.parseInt(st.nextToken());
        this.appName_ = st.nextToken();
        this.domain_ = this.getDomainPrefix() + domainSeparator + this.host_ + domainSeparator + Integer.toString(this.port_) + domainSeparator + this.appName_;
        this.login_ = login;
        this.sagar_ = pwd;
        this.securedomain_ = this.domain_ + domainSeparator + login + domainSeparator + pwd;
    }

    public String getHost() {
        return this.host_;
    }

    public int getPort() {
        return this.port_;
    }

    public final String getPrincipal() {
        return this.login_;
    }

    public final String getCredential() {
        return this.sagar_;
    }

    public String toString() {
        return this.domain_;
    }

    public boolean checkDomainEquality(Domain dom) {
        return this.toString().equals(dom.toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof DomainBase) {
            return this.getSecureDomain().equals(((DomainBase)obj).getSecureDomain());
        }
        return false;
    }

    public int hashCode() {
        return this.getSecureDomain().hashCode();
    }

    protected String getSecureDomain() {
        return this.securedomain_;
    }

    protected abstract String getDomainPrefix();

    public final String getDomainName() {
        return this.getDomainPrefix();
    }

    public String getApplication() {
        return this.appName_;
    }

    public boolean isAccessRestricted() {
        return false;
    }

    public abstract ObjectName getDeployerName();

    public abstract ObjectName getUploaderName();

    public Locale getLocale() {
        return this.loc_ == null ? Locale.getDefault() : this.loc_;
    }

    public void setLocale(Locale loc) {
        this.loc_ = loc;
    }

    public String getHttpTunnelingPath() {
        return this.httpTunnelingPath_;
    }

    public void setHttpTunnelingPath(String pathToServlet) {
        this.httpTunnelingPath_ = pathToServlet;
    }

    public boolean isCachingOn() {
        return this.isCachingOn_;
    }

    public void setConnectionCaching(boolean policy) {
        this.isCachingOn_ = policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(String key, Object value) {
        Map map = this.extraProperties_;
        synchronized (map) {
            this.extraProperties_.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String key) {
        Map map = this.extraProperties_;
        synchronized (map) {
            return this.extraProperties_.get(key);
        }
    }

    public MBeanServer getMBeanServer() throws JMXRuntimeException {
        String domain = (String)this.getProperty("proprietary_MBeanServer");
        if (domain == null) {
            return null;
        }
        ArrayList<MBeanServer> allMBeanServers = MBeanServerFactory.findMBeanServer(null);
        if (allMBeanServers == null || allMBeanServers.size() == 0) {
            throw new JMXRuntimeException("No MBeanServer registered for domain: " + domain);
        }
        Iterator it = allMBeanServers.iterator();
        while (it.hasNext()) {
            MBeanServer mbsrv = (MBeanServer)it.next();
            String defaultDomain = mbsrv.getDefaultDomain();
            if (!domain.equals(defaultDomain)) continue;
            return mbsrv;
        }
        throw new JMXRuntimeException("No MBeanServer registered for domain: " + domain);
    }
}

