/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.client;

import java.util.StringTokenizer;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.Oc4jOpmnRmiApplicationLevelDomain;
import oracle.oc4j.admin.jmx.shared.Oc4jOpmnRmiDomain;
import oracle.oc4j.admin.jmx.shared.Oc4jRmiApplicationLevelDomain;
import oracle.oc4j.admin.jmx.shared.Oc4jRmiDomain;

public class Oc4jDomainFactory {
    public static Domain getDomain(String host, int rmiPort, String login, String pwd) {
        return new Oc4jRmiDomain(host, rmiPort, login, pwd);
    }

    public static Domain getDomain(String host, int rmiPort, String login, String pwd, String appName) {
        return new Oc4jRmiApplicationLevelDomain(host, rmiPort, login, pwd, appName);
    }

    public static Domain getDomain(String host, int rmiPort) {
        return new Oc4jRmiDomain(host, rmiPort);
    }

    public static Domain getDomain(String host, int rmiPort, String appName) {
        return new Oc4jRmiApplicationLevelDomain(host, rmiPort, appName);
    }

    public static Domain getDomain(String domain) {
        if (domain.indexOf("opmn") != -1 || domain.indexOf("OPMN") != -1) {
            if (domain.indexOf("default") != -1) {
                return new Oc4jOpmnRmiApplicationLevelDomain(domain);
            }
            return new Oc4jOpmnRmiDomain(domain);
        }
        if (domain.indexOf("default") != -1) {
            return new Oc4jRmiApplicationLevelDomain(domain);
        }
        return new Oc4jRmiDomain(domain);
    }

    public static Domain getDomain(String domain, String login, String pwd) {
        if (domain.indexOf("opmn") != -1 || domain.indexOf("OPMN") != -1) {
            if (domain.indexOf("default") != -1) {
                return new Oc4jOpmnRmiApplicationLevelDomain(domain, login, pwd);
            }
            return new Oc4jOpmnRmiDomain(domain, login, pwd);
        }
        if (domain.indexOf("default") != -1) {
            return new Oc4jRmiApplicationLevelDomain(domain, login, pwd);
        }
        return new Oc4jRmiDomain(domain, login, pwd);
    }

    public static Domain getDomainFromDeployerUrl(String deployerUrl, String login, String pwd) {
        String protocolProperty = null;
        StringTokenizer strTok = new StringTokenizer(deployerUrl, ":");
        if (strTok.countTokens() < 1) {
            throw new IllegalArgumentException("Invalid deployer url: " + deployerUrl);
        }
        if (strTok.countTokens() == 1) {
            return new Oc4jRmiDomain("localhost", 23791, login, pwd);
        }
        strTok.nextToken();
        strTok.nextToken();
        String host = strTok.nextToken();
        if ("rmis".equalsIgnoreCase(host) || "ormis".equalsIgnoreCase(host)) {
            protocolProperty = "ormis";
            host = strTok.nextToken();
        }
        if ("rmi".equalsIgnoreCase(host) || "ormi".equalsIgnoreCase(host)) {
            host = strTok.nextToken();
        }
        if ("opmn".equalsIgnoreCase(host)) {
            host = strTok.nextToken();
            if (host == null || host.length() < 2) {
                throw new IllegalArgumentException("Invalid URL: " + deployerUrl);
            }
            host = host.substring(2);
            int port = 6003;
            String iasInstance = null;
            String oc4jInstance = null;
            if (strTok.countTokens() > 0) {
                String portAndInstance = strTok.nextToken();
                StringTokenizer strTokb = new StringTokenizer(portAndInstance, "/");
                port = Integer.parseInt(strTokb.nextToken());
                if (strTokb.countTokens() > 1) {
                    iasInstance = strTokb.nextToken();
                    oc4jInstance = strTokb.nextToken();
                } else {
                    oc4jInstance = strTokb.nextToken();
                }
            } else {
                StringTokenizer strTokb = new StringTokenizer(host, "/");
                host = strTokb.nextToken();
                if (strTokb.countTokens() > 1) {
                    iasInstance = strTokb.nextToken();
                    oc4jInstance = strTokb.nextToken();
                } else {
                    oc4jInstance = strTokb.nextToken();
                }
            }
            if (host == null || host.length() == 0) {
                throw new IllegalArgumentException("Missing host parameter in URL: " + deployerUrl);
            }
            if (oc4jInstance == null || oc4jInstance.length() == 0) {
                throw new IllegalArgumentException("Missing OC4J instance parameter in URL: " + deployerUrl);
            }
            Oc4jOpmnRmiDomain domain = new Oc4jOpmnRmiDomain(host, port, oc4jInstance, iasInstance, login, pwd);
            domain.setConnectionCaching(false);
            if (protocolProperty != null) {
                domain.addProperty("com.oracle.jmx.remote.oc4j.wireprotocol", protocolProperty);
            }
            return domain;
        }
        int port = 23791;
        if (strTok.countTokens() > 0) {
            port = Integer.parseInt(strTok.nextToken());
        }
        Oc4jRmiDomain domain = new Oc4jRmiDomain(host, port, login, pwd);
        domain.setConnectionCaching(false);
        if (protocolProperty != null) {
            domain.addProperty("com.oracle.jmx.remote.oc4j.wireprotocol", protocolProperty);
        }
        return domain;
    }

    public static Domain getDomainFromJmx4antUrl(String url, String login, String pwd) {
        if (url == null) {
            throw new IllegalArgumentException("JMX url cannot be null");
        }
        if (!url.startsWith("jmx://") && !url.startsWith("JMX://")) {
            throw new IllegalArgumentException("Invalid JMX url. The url must be of the form jmx://host:port");
        }
        if (url.length() < 7) {
            throw new IllegalArgumentException("Invalid JMX url. The url must be of the form jmx://host:port");
        }
        String hostPort = url.substring(6);
        StringTokenizer strTok = new StringTokenizer(hostPort, ":");
        if (strTok.countTokens() < 2) {
            throw new IllegalArgumentException("Invalid JMX url. The url must be of the form jmx://host:port");
        }
        String host = strTok.nextToken();
        int port = Integer.parseInt(strTok.nextToken());
        if (strTok.countTokens() > 0) {
            String appName = strTok.nextToken();
            return Oc4jDomainFactory.getDomain(host, port, login, pwd, appName);
        }
        return Oc4jDomainFactory.getDomain(host, port, login, pwd);
    }
}

