/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.PropertyTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SignElementsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SignElementsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SignatureMethodsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SignatureMethodsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.TimestampConfigType;
import oracle.oc4j.admin.deploy.spi.xml.TimestampTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.VerifySignatureConfigType;

public class VerifySignatureTreeNode
extends ConfigTreeNode
implements ActionListener {
    private VerifySignatureConfigType _bean;
    private static final String ADD_SIGNATURE_METHODS_MENU_STRING = "Add Signature Methods";
    private static final String ADD_TBS_ELEMENTS_MENU_STRING = "Add Tbs Elements";
    private static final String VERIFY_TIMESTAMP_TEXT = "Verify Timestamp";
    private static final String ADD_VERIFY_TIMESTAMP_MENU_STRING = "Add Verify Timestamp";
    private static final String ADD_PROPERTY_MENU_STRING = "Add Property";
    private static final String REMOVE_VERIFY_SIGNATURE_MENU_STRING = "Remove Verify Signature";
    private JMenuItem _addSignatureMethodsMenuItem;
    private JMenuItem _addTbsElementsMenuItem;
    private JMenuItem _addVerifyTimestampMenuItem;
    private JMenuItem _addPropertyMenuItem;
    private JMenuItem _removeVerifySignatureMenuItem;

    public VerifySignatureTreeNode(ConfigTreeNode rootNode, VerifySignatureConfigType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addSignatureMethodsMenuItem = new JMenuItem(ADD_SIGNATURE_METHODS_MENU_STRING);
        this._addSignatureMethodsMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSignatureMethodsMenuItem.setFont(VerifySignatureTreeNode.getFont());
        this._addSignatureMethodsMenuItem.addActionListener(this);
        if (this._bean.getSignatureMethods() != null) {
            this._addSignatureMethodsMenuItem.setEnabled(false);
        }
        this._addTbsElementsMenuItem = new JMenuItem(ADD_TBS_ELEMENTS_MENU_STRING);
        this._addTbsElementsMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addTbsElementsMenuItem.setFont(VerifySignatureTreeNode.getFont());
        this._addTbsElementsMenuItem.addActionListener(this);
        if (this._bean.getTbsElements() != null) {
            this._addTbsElementsMenuItem.setEnabled(false);
        }
        this._addVerifyTimestampMenuItem = new JMenuItem(ADD_VERIFY_TIMESTAMP_MENU_STRING);
        this._addVerifyTimestampMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addVerifyTimestampMenuItem.setFont(VerifySignatureTreeNode.getFont());
        this._addVerifyTimestampMenuItem.addActionListener(this);
        if (this._bean.getVerifyTimestamp() != null) {
            this._addVerifyTimestampMenuItem.setEnabled(false);
        }
        this._addPropertyMenuItem = new JMenuItem(ADD_PROPERTY_MENU_STRING);
        this._addPropertyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPropertyMenuItem.setFont(VerifySignatureTreeNode.getFont());
        this._addPropertyMenuItem.addActionListener(this);
        this._removeVerifySignatureMenuItem = new JMenuItem(REMOVE_VERIFY_SIGNATURE_MENU_STRING);
        this._removeVerifySignatureMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeVerifySignatureMenuItem.setFont(VerifySignatureTreeNode.getFont());
        this._removeVerifySignatureMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addSignatureMethodsMenuItem);
        this._popup.add(this._addTbsElementsMenuItem);
        this._popup.add(this._addVerifyTimestampMenuItem);
        this._popup.add(this._addPropertyMenuItem);
        this._popup.add(this._removeVerifySignatureMenuItem);
    }

    public String viewHeaderString() {
        return "Verify Signature";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        PropertyConfigBean[] properties;
        TimestampConfigType verifyTimestamp;
        SignElementsConfigType tbsElements;
        SignatureMethodsConfigType signatureMethods = this._bean.getSignatureMethods();
        if (signatureMethods != null) {
            SignatureMethodsTreeNode signatureMethodsTreeNode = new SignatureMethodsTreeNode(this.getRootNode(), signatureMethods);
            this.addChild(signatureMethodsTreeNode);
        }
        if ((tbsElements = this._bean.getTbsElements()) != null) {
            SignElementsTreeNode tbsElementsTreeNode = new SignElementsTreeNode(this.getRootNode(), tbsElements);
            this.addChild(tbsElementsTreeNode);
        }
        if ((verifyTimestamp = this._bean.getVerifyTimestamp()) != null) {
            TimestampTreeNode verifyTimestampTreeNode = new TimestampTreeNode(this.getRootNode(), verifyTimestamp, VERIFY_TIMESTAMP_TEXT);
            this.addChild(verifyTimestampTreeNode);
        }
        if ((properties = this._bean.getProperties()) != null) {
            for (int i = 0; i < properties.length; ++i) {
                PropertyConfigBean property = properties[i];
                if (property == null) continue;
                PropertyTreeNode propertyTreeNode = new PropertyTreeNode(this.getRootNode(), property);
                this.addChild(propertyTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_SIGNATURE_METHODS_MENU_STRING)) {
                if (this._bean.getSignatureMethods() == null) {
                    this._bean.addSignatureMethods();
                    SignatureMethodsTreeNode newNode = new SignatureMethodsTreeNode(this, this._bean.getSignatureMethods());
                    this.insertNode(newNode);
                    this._addSignatureMethodsMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_TBS_ELEMENTS_MENU_STRING)) {
                if (this._bean.getTbsElements() == null) {
                    this._bean.addTbsElements();
                    SignElementsTreeNode newNode = new SignElementsTreeNode(this, this._bean.getTbsElements());
                    this.insertNode(newNode);
                    this._addTbsElementsMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_VERIFY_TIMESTAMP_MENU_STRING)) {
                TimestampConfigType newVerifyTimestamp = this._bean.defaultVerifyTimestamp();
                if (this.showAddDialog(newVerifyTimestamp, ADD_VERIFY_TIMESTAMP_MENU_STRING)) {
                    this._bean.setVerifyTimestamp(newVerifyTimestamp);
                    TimestampTreeNode newNode = new TimestampTreeNode(this, newVerifyTimestamp, VERIFY_TIMESTAMP_TEXT);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(ADD_PROPERTY_MENU_STRING)) {
                PropertyConfigBean newProperty = new PropertyConfigBean(this._bean);
                if (this.showAddDialog(newProperty, ADD_PROPERTY_MENU_STRING)) {
                    this._bean.addProperty(newProperty);
                    PropertyTreeNode newNode = new PropertyTreeNode(this, newProperty);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(REMOVE_VERIFY_SIGNATURE_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof SignatureMethodsTreeNode) {
            this._bean.removeSignatureMethods();
            this.removeNode(node);
            this._addSignatureMethodsMenuItem.setEnabled(true);
        } else if (node instanceof SignElementsTreeNode) {
            this._bean.removeTbsElements();
            this.removeNode(node);
            this._addTbsElementsMenuItem.setEnabled(true);
        } else if (node instanceof TimestampTreeNode) {
            this._bean.removeVerifyTimestamp();
            this.removeNode(node);
            this._addVerifyTimestampMenuItem.setEnabled(true);
        } else if (node instanceof PropertyTreeNode) {
            PropertyConfigBean property = (PropertyConfigBean)node.getConfigBeanNode();
            this._bean.removeProperty(property);
            this.removeNode(node);
        }
    }
}

