/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.SignElementsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SignatureMethodsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.TimestampConfigType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifySignatureConfigType
extends ConfigBeanNode {
    SignatureMethodsConfigType _signatureMethods = null;
    SignElementsConfigType _tbsElements = null;
    TimestampConfigType _verifyTimestamp = null;
    PropertyConfigBean[] _properties = null;

    public VerifySignatureConfigType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public VerifySignatureConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setSignatureMethods(SignatureMethodsConfigType signatureMethods) throws ConfigurationException {
        SignatureMethodsConfigType oldValue = this._signatureMethods;
        this._signatureMethods = signatureMethods;
        this.firePropertyChange("signatureMethods", oldValue, this._signatureMethods);
    }

    public SignatureMethodsConfigType getSignatureMethods() {
        return this._signatureMethods;
    }

    public SignatureMethodsConfigType defaultSignatureMethods() {
        try {
            return new SignatureMethodsConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addSignatureMethods() throws ConfigurationException {
        if (this._signatureMethods != null) {
            return;
        }
        SignatureMethodsConfigType signatureMethods = new SignatureMethodsConfigType(this, null);
        this.setSignatureMethods(signatureMethods);
    }

    public void removeSignatureMethods() throws ConfigurationException {
        if (this._signatureMethods == null) {
            return;
        }
        this.setSignatureMethods(null);
    }

    public void setTbsElements(SignElementsConfigType tbsElements) throws ConfigurationException {
        SignElementsConfigType oldValue = this._tbsElements;
        this._tbsElements = tbsElements;
        this.firePropertyChange("tbsElements", oldValue, this._tbsElements);
    }

    public SignElementsConfigType getTbsElements() {
        return this._tbsElements;
    }

    public SignElementsConfigType defaultTbsElements() {
        try {
            return new SignElementsConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addTbsElements() throws ConfigurationException {
        if (this._tbsElements != null) {
            return;
        }
        SignElementsConfigType tbsElements = new SignElementsConfigType(this, null);
        this.setTbsElements(tbsElements);
    }

    public void removeTbsElements() throws ConfigurationException {
        if (this._tbsElements == null) {
            return;
        }
        this.setTbsElements(null);
    }

    public void setVerifyTimestamp(TimestampConfigType verifyTimestamp) throws ConfigurationException {
        TimestampConfigType oldValue = this._verifyTimestamp;
        this._verifyTimestamp = verifyTimestamp;
        this.firePropertyChange("verifyTimestamp", oldValue, this._verifyTimestamp);
    }

    public TimestampConfigType getVerifyTimestamp() {
        return this._verifyTimestamp;
    }

    public TimestampConfigType defaultVerifyTimestamp() throws ConfigurationException {
        try {
            return new TimestampConfigType(this, "verify-timestamp", null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addVerifyTimestamp() throws ConfigurationException {
        if (this._verifyTimestamp != null) {
            return;
        }
        TimestampConfigType verifyTimestamp = new TimestampConfigType(this, "verify-timestamp", null);
        this.setVerifyTimestamp(verifyTimestamp);
    }

    public void removeVerifyTimestamp() throws ConfigurationException {
        if (this._verifyTimestamp == null) {
            return;
        }
        this.setVerifyTimestamp(null);
    }

    public void setProperties(PropertyConfigBean[] properties) throws ConfigurationException {
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        return new PropertyConfigBean[0];
    }

    public void addProperties() throws ConfigurationException {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() throws ConfigurationException {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) throws ConfigurationException {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) throws ConfigurationException {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "verify-signature");
        XMLUtils.writeTagAttributeEnd(out, indentation, "verify-signature");
        if (this._signatureMethods != null) {
            this._signatureMethods.writeXML(out, indentation + "\t");
        }
        if (this._tbsElements != null) {
            this._tbsElements.writeXML(out, indentation + "\t");
        }
        if (this._verifyTimestamp != null) {
            this._verifyTimestamp.writeXML(out, indentation + "\t");
        }
        VerifySignatureConfigType.writeXML(out, indentation + "\t", this._properties);
        XMLUtils.writeTagEnd(out, indentation, "verify-signature");
    }

    private void init() throws ConfigurationException {
        this.setXpath("verify-signature");
        Vector<PropertyConfigBean> properties = new Vector<PropertyConfigBean>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("signature-methods")) {
                    this.setSignatureMethods(new SignatureMethodsConfigType(this, node));
                    continue;
                }
                if (name.equals("tbs-elements")) {
                    this.setTbsElements(new SignElementsConfigType(this, node));
                    continue;
                }
                if (name.equals("verify-timestamp")) {
                    TimestampConfigType verifyTimestamp = new TimestampConfigType(this, "verify-timestamp", node);
                    this.setVerifyTimestamp(verifyTimestamp);
                    continue;
                }
                if (!name.equals("property")) continue;
                PropertyConfigBean configBean = new PropertyConfigBean(this, node);
                properties.add(configBean);
            }
        }
        if (properties.size() > 0) {
            this.setProperties(properties.toArray(new PropertyConfigBean[0]));
        }
    }
}

