/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SecurityRoleMappingConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.UserTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.UserType;
import oracle.oc4j.admin.deploy.spi.xml.UsersType;

public class UsersTreeNode
extends ConfigTreeNode
implements ActionListener {
    private SecurityRoleMappingConfigBean _bean;
    private Method _method;
    private static final String ADD_USER_MENU_STRING = "Add User";
    private JMenuItem _addUserMenuItem;

    public UsersTreeNode(ConfigTreeNode rootNode, UsersType users) {
        super(users);
        this.setRootNode(rootNode);
        this._bean = (SecurityRoleMappingConfigBean)users.getConfigParent();
        this._addUserMenuItem = new JMenuItem(ADD_USER_MENU_STRING);
        this._addUserMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addUserMenuItem.setFont(UsersTreeNode.getFont());
        this._addUserMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addUserMenuItem);
    }

    public String viewHeaderString() {
        return "Users";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        UserType[] users = this._bean.getUsers();
        if (users != null) {
            for (int i = 0; i < users.length; ++i) {
                UserType user = users[i];
                if (user == null) continue;
                UserTreeNode userTreeNode = new UserTreeNode(this.getRootNode(), user);
                this.addChild(userTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            UserType newUser;
            if (event.getActionCommand().equals(ADD_USER_MENU_STRING) && this.showAddDialog(newUser = new UserType(this._bean), ADD_USER_MENU_STRING)) {
                this._bean.addUser(newUser);
                UserTreeNode newNode = new UserTreeNode(this, newUser);
                this.insertNode(newNode);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof UserTreeNode) {
            UserType user = (UserType)node.getConfigBeanNode();
            this._bean.removeUser(user);
            this.removeNode(node);
        }
    }
}

