/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.NamespaceResourceType;
import oracle.oc4j.admin.deploy.spi.xml.UserNameType;

public class UserType
extends ConfigBeanNode {
    protected UserNameType _name = null;
    protected String _description = null;

    public UserType(ConfigBeanNode parent) {
        super(null, parent);
        if (parent instanceof NamespaceResourceType) {
            this.setXpath("security-role-mapping/user");
        } else {
            this.setXpath("user");
        }
    }

    public UserNameType getName() {
        return this._name;
    }

    public void setName(UserNameType name) {
        UserNameType oldValue = this._name;
        this._name = name;
        String oldDesc = this._description;
        this._description = name == null ? null : name.getDescription();
        if (this._description == null) {
            this._description = "";
        }
        this.firePropertyChange("name", oldValue, this._name);
        this.firePropertyChange("description", oldDesc, this._description);
    }

    public UserNameType defaultName() {
        return new UserNameType(this);
    }

    public String getDescription() {
        return this._description;
    }

    public String defaultDescription() {
        return "";
    }

    public boolean validatePropertyValue(String name, Object value) {
        return !name.equals("name") || value != null && value instanceof String && ((String)value).length() != 0;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._name == null || this._name.getValue() == null || this._name.getValue().length() == 0) {
            return;
        }
        XMLUtils.writeTagAttributeStart(out, indentation, "user");
        XMLUtils.writeAttribute(out, indentation, "name", this._name.getValue());
        XMLUtils.writeTagAttributeEnd(out, indentation, "user");
        XMLUtils.writeTagEnd(out, indentation, "user");
    }

    public static void writeXML(PrintWriter out, String indentation, UserType[] users) throws ExtendedRuntimeException {
        if (users == null) {
            return;
        }
        for (int n = 0; n < users.length; ++n) {
            users[n].writeXML(out, indentation + "\t");
        }
    }

    public String toString() {
        if (this._name != null) {
            return this._name.getValue();
        }
        return "";
    }

    public String getPropertyDoc(String propertyName) {
        if (propertyName != null && propertyName.equals("description")) {
            return FormattingResourceBundle.DeploymentMessages.getString("userDescription");
        }
        return super.getPropertyDoc(propertyName);
    }
}

