/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import org.w3c.dom.Node;

public class SignatureMethodConfigType
extends ConfigBeanNode {
    StringType _method = null;
    StringType _oldMethod = null;

    public SignatureMethodConfigType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public SignatureMethodConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setMethod(StringType method) throws ConfigurationException {
        this._method = method;
        this.firePropertyChange("method", this._oldMethod, this._method);
        if (this._method != null) {
            if (this._oldMethod == null) {
                this._oldMethod = this.defaultMethod();
            }
            this._oldMethod.setValue(this._method.getValue());
        } else {
            this._oldMethod = null;
        }
    }

    public StringType getMethod() {
        return this._method;
    }

    public StringType defaultMethod() {
        String[] tags = new String[]{"RSA-SHA1", "RSA-MD5", "DSA-SHA1"};
        return new StringType(this, tags, "RSA-SHA1");
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTag(out, indentation, "signature-method", this._method);
    }

    private void init() throws ConfigurationException {
        this.setXpath("signature-method");
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            this._method = this.defaultMethod();
            this._method.setValue(XMLUtils.getValue(node));
        }
    }
}

