/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.ArrayList;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.IconType;
import oracle.oc4j.admin.deploy.spi.xml.RunAsType;
import oracle.oc4j.admin.deploy.spi.xml.SecurityRoleRefType;
import oracle.oc4j.admin.deploy.spi.xml.WebInitParamType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServletType
extends ConfigBeanNode {
    IconType icon;
    String servletName;
    String displayName;
    String description;
    String servletClass;
    String jspFile;
    WebInitParamType[] initParams = null;
    String loadOnStartUp;
    RunAsType runAs = null;
    SecurityRoleRefType[] securityRoleRefs = null;

    public ServletType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("servlet");
        ArrayList<WebInitParamType> initParamList = new ArrayList<WebInitParamType>();
        ArrayList<SecurityRoleRefType> securityRoleRefList = new ArrayList<SecurityRoleRefType>();
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals("icon")) {
                    this.icon = new IconType(this, childNode);
                    continue;
                }
                if (nodeName.equals("servlet-name")) {
                    this.servletName = XMLUtils.getValue(childNode);
                    continue;
                }
                if (nodeName.equals("display-name")) {
                    this.displayName = XMLUtils.getValue(childNode);
                    continue;
                }
                if (nodeName.equals("description")) {
                    this.description = XMLUtils.getValue(childNode);
                    continue;
                }
                if (nodeName.equals("servlet-class")) {
                    this.servletClass = XMLUtils.getValue(childNode);
                    continue;
                }
                if (nodeName.equals("jsp-file")) {
                    this.jspFile = XMLUtils.getValue(childNode);
                    continue;
                }
                if (nodeName.equals("init-param")) {
                    initParamList.add(new WebInitParamType(this, childNode));
                    continue;
                }
                if (nodeName.equals("load-on-startup")) {
                    this.loadOnStartUp = XMLUtils.getValue(childNode);
                    continue;
                }
                if (nodeName.equals("run-as")) {
                    this.runAs = new RunAsType(this, childNode);
                    continue;
                }
                if (!nodeName.equals("security-role-ref")) continue;
                securityRoleRefList.add(new SecurityRoleRefType(this, childNode));
            }
        }
        if (!initParamList.isEmpty()) {
            this.initParams = initParamList.toArray(new WebInitParamType[0]);
        }
        if (!securityRoleRefList.isEmpty()) {
            this.securityRoleRefs = securityRoleRefList.toArray(new SecurityRoleRefType[0]);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "servlet");
        if (this.icon != null) {
            this.icon.writeXML(out, indentation);
        }
        XMLUtils.writeTagWithValue(out, indentation + "\t", "servlet-name", this.servletName);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "display-name", this.displayName);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "description", this.description);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "servlet-class", this.servletClass);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "jsp-file", this.jspFile);
        ServletType.writeXML(out, indentation + "\t", this.getInitParams());
        XMLUtils.writeTagWithValue(out, indentation + "\t", "load-on-startup", this.loadOnStartUp);
        if (this.runAs != null) {
            this.runAs.writeXML(out, indentation + "\t");
        }
        ServletType.writeXML(out, indentation, this.securityRoleRefs);
        XMLUtils.writeTagEnd(out, indentation + "\t", "servlet");
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public IconType getIcon() {
        return this.icon;
    }

    public WebInitParamType[] getInitParams() {
        return this.initParams;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public String getLoadOnStartUp() {
        return this.loadOnStartUp;
    }

    public RunAsType getRunAs() {
        return this.runAs;
    }

    public SecurityRoleRefType[] getSecurityRoleRefs() {
        return this.securityRoleRefs;
    }

    public String getServletClass() {
        return this.servletClass;
    }

    public String getServletName() {
        return this.servletName;
    }
}

