/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.tree.TreePath;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.CallPropertyType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTree;
import oracle.oc4j.admin.deploy.spi.xml.PortInfoType;
import oracle.oc4j.admin.deploy.spi.xml.ServiceQnameType;
import oracle.oc4j.admin.deploy.spi.xml.ServiceRefMappingTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.StubPropertyType;
import oracle.oc4j.admin.deploy.spi.xml.TypeMappingsType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceRefMappingConfigBean
extends ConfigBeanNode {
    protected String _name = null;
    protected String _wsdlLocation = null;
    protected ServiceQnameType _serviceQname = null;
    protected TypeMappingsType _typeMappings = null;
    protected StubPropertyType[] _stubProperties = null;
    protected CallPropertyType[] _callProperties = null;
    protected PortInfoType[] _portInfo = null;

    public ServiceRefMappingConfigBean(DDBean stdBean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init();
    }

    public ServiceRefMappingConfigBean(ConfigBeanNode parent, Node node) throws ConfigurationException {
        this(null, parent, node);
    }

    public String getName() {
        return this._name;
    }

    public String defaultName() {
        return "";
    }

    public String key() {
        return this.getName();
    }

    public String beanKey() {
        return "service-ref-name";
    }

    public void setWsdlLocation(String wsdlLocation) {
        String oldValue = this._wsdlLocation;
        this._wsdlLocation = wsdlLocation;
        this.firePropertyChange("wsdlLocation", oldValue, this._wsdlLocation);
    }

    public String getWsdlLocation() {
        return this._wsdlLocation;
    }

    public String defaultWsdlLocation() {
        return "";
    }

    public ServiceQnameType getServiceQname() {
        return this._serviceQname;
    }

    public void setServiceQname(ServiceQnameType serviceQname) {
        ServiceQnameType oldValue = this._serviceQname;
        this._serviceQname = serviceQname;
        this.firePropertyChange("serviceQname", oldValue, this._serviceQname);
    }

    public void addServiceQname() {
        if (this._serviceQname != null) {
            return;
        }
        ServiceQnameType serviceQname = new ServiceQnameType(this, null);
        this.setServiceQname(serviceQname);
    }

    public void removeServiceQname() {
        if (this._serviceQname == null) {
            return;
        }
        this.setServiceQname(null);
    }

    public ServiceQnameType defaultServiceQname() {
        return new ServiceQnameType(this, null);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "service-ref-mapping");
        XMLUtils.writeAttribute(out, indentation, "name", this._name);
        XMLUtils.writeTagAttributeEnd(out, indentation, "service-ref-mapping");
        if (this._wsdlLocation != null && this._wsdlLocation.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "wsdl-location", this._wsdlLocation);
        }
        if (this._serviceQname != null) {
            this._serviceQname.writeXML(out, indentation + "\t");
        }
        if (this._typeMappings != null) {
            this._typeMappings.writeXML(out, indentation + "\t");
        }
        StubPropertyType.writeXML(out, indentation, this._stubProperties);
        CallPropertyType.writeXML(out, indentation, this._callProperties);
        PortInfoType.writeXML(out, indentation, this._portInfo);
        XMLUtils.writeTagEnd(out, indentation, "service-ref-mapping");
    }

    public void writeStubPropertiesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        StubPropertyType.writeXML(out, indentation, this._stubProperties);
    }

    public void writeCallPropertiesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        CallPropertyType.writeXML(out, indentation, this._callProperties);
    }

    public void writePortInfosXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        PortInfoType.writeXML(out, indentation, this._portInfo);
    }

    private void init() throws ConfigurationException {
        this.setXpath("service-ref-mapping");
        Vector<StubPropertyType> stubProperties = new Vector<StubPropertyType>();
        Vector<CallPropertyType> callProperties = new Vector<CallPropertyType>();
        Vector<PortInfoType> portInfos = new Vector<PortInfoType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "name");
            if (val != null && !val.trim().equals("")) {
                this._name = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("wsdl-location")) {
                    this._wsdlLocation = XMLUtils.getValue(node);
                    continue;
                }
                if (name.equals("type-mappings")) {
                    TypeMappingsType typeMappings = new TypeMappingsType(this, node);
                    this.setTypeMappings(typeMappings);
                    continue;
                }
                if (name.equals("stub-property")) {
                    StubPropertyType stubProperty = new StubPropertyType(this, node);
                    stubProperties.add(stubProperty);
                    continue;
                }
                if (name.equals("call-property")) {
                    CallPropertyType callProperty = new CallPropertyType(this, node);
                    callProperties.add(callProperty);
                    continue;
                }
                if (name.equals("port-info")) {
                    PortInfoType portInfo = new PortInfoType(this, node);
                    portInfos.add(portInfo);
                    continue;
                }
                if (!name.equals("service-qname")) continue;
                this._serviceQname = new ServiceQnameType(this, node);
            }
        } else if (this.getDDBean() != null && this.getDDBean().getText(this.beanKey()) != null) {
            this._name = this.getDDBean().getText(this.beanKey())[0];
        }
        if (stubProperties.size() > 0) {
            this.setStubProperties(stubProperties.toArray(new StubPropertyType[0]));
        }
        if (callProperties.size() > 0) {
            this.setCallProperties(callProperties.toArray(new CallPropertyType[0]));
        }
        if (portInfos.size() > 0) {
            this.setPortInfo(portInfos.toArray(new PortInfoType[0]));
        }
    }

    public ViewableJTree[] subTrees() {
        ServiceRefMappingTreeNode treeNode = new ServiceRefMappingTreeNode(this);
        treeNode.setTreePath(new TreePath(treeNode));
        ConfigTree tree = new ConfigTree(treeNode);
        treeNode.setTree(tree);
        return new ViewableJTree[]{tree};
    }

    public void setTypeMappings(TypeMappingsType typeMappings) throws ConfigurationException {
        TypeMappingsType oldValue = this._typeMappings;
        this._typeMappings = typeMappings;
        this.firePropertyChange("typeMappings", oldValue, this._typeMappings);
    }

    public TypeMappingsType getTypeMappings() {
        return this._typeMappings;
    }

    public TypeMappingsType defaultTypeMappings() throws ConfigurationException {
        try {
            return new TypeMappingsType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addTypeMappings() throws ConfigurationException {
        if (this._typeMappings != null) {
            return;
        }
        TypeMappingsType typeMappings = new TypeMappingsType(this, null);
        this.setTypeMappings(typeMappings);
    }

    public void removeTypeMappings() throws ConfigurationException {
        if (this._typeMappings == null) {
            return;
        }
        this.setTypeMappings(null);
    }

    public void setStubProperties(StubPropertyType[] stubProperties) {
        StubPropertyType[] oldValue = this._stubProperties;
        this._stubProperties = stubProperties;
        this.firePropertyChange("stubProperties", oldValue, this._stubProperties);
    }

    public StubPropertyType[] getStubProperties() {
        return this._stubProperties;
    }

    public StubPropertyType[] defaultStubProperties() {
        StubPropertyType[] ret = new StubPropertyType[]{new StubPropertyType(this)};
        return ret;
    }

    public void addStubProperties() {
        if (this._stubProperties != null) {
            return;
        }
        StubPropertyType[] stubProperties = new StubPropertyType[]{new StubPropertyType(this, null)};
        this.setStubProperties(stubProperties);
    }

    public void removeStubProperties() {
        if (this._stubProperties == null) {
            return;
        }
        this.setStubProperties(null);
    }

    public void addStubProperty(StubPropertyType stubProperty) {
        stubProperty.setParent(this);
        int existingStubPropertiesCnt = 0;
        if (this._stubProperties != null) {
            existingStubPropertiesCnt = this._stubProperties.length;
        }
        StubPropertyType[] newStubProperties = new StubPropertyType[existingStubPropertiesCnt + 1];
        for (int n = 0; n < existingStubPropertiesCnt; ++n) {
            newStubProperties[n] = this._stubProperties[n];
        }
        newStubProperties[existingStubPropertiesCnt] = stubProperty;
        StubPropertyType[] oldValue = this._stubProperties;
        this._stubProperties = newStubProperties;
        this.firePropertyChange("stubProperties", oldValue, this._stubProperties);
    }

    public void removeStubProperty(StubPropertyType stubProperty) {
        int existingStubPropertiesCnt = 0;
        if (this._stubProperties != null) {
            existingStubPropertiesCnt = this._stubProperties.length;
        }
        StubPropertyType[] newStubProperties = new StubPropertyType[existingStubPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingStubPropertiesCnt; ++n) {
            if (stubProperty.equals(this._stubProperties[n])) continue;
            newStubProperties[newIndex++] = this._stubProperties[n];
        }
        if (newStubProperties.length == 0) {
            newStubProperties = null;
        }
        StubPropertyType[] oldValue = this._stubProperties;
        this._stubProperties = newStubProperties;
        this.firePropertyChange("stubProperties", oldValue, this._stubProperties);
    }

    public void setCallProperties(CallPropertyType[] callProperties) {
        CallPropertyType[] oldValue = this._callProperties;
        this._callProperties = callProperties;
        this.firePropertyChange("callProperties", oldValue, this._callProperties);
    }

    public CallPropertyType[] getCallProperties() {
        return this._callProperties;
    }

    public CallPropertyType[] defaultCallProperties() {
        CallPropertyType[] ret = new CallPropertyType[]{new CallPropertyType(this.getConfigParent())};
        return ret;
    }

    public void addCallProperties() {
        if (this._callProperties != null) {
            return;
        }
        CallPropertyType[] callProperties = new CallPropertyType[]{new CallPropertyType(this.getConfigParent(), null)};
        this.setCallProperties(callProperties);
    }

    public void removeCallProperties() {
        if (this._callProperties == null) {
            return;
        }
        this.setCallProperties(null);
    }

    public void addCallProperty(CallPropertyType callProperty) {
        callProperty.setParent(this.getConfigParent());
        int existingCallPropertiesCnt = 0;
        if (this._callProperties != null) {
            existingCallPropertiesCnt = this._callProperties.length;
        }
        CallPropertyType[] newCallProperties = new CallPropertyType[existingCallPropertiesCnt + 1];
        for (int n = 0; n < existingCallPropertiesCnt; ++n) {
            newCallProperties[n] = this._callProperties[n];
        }
        newCallProperties[existingCallPropertiesCnt] = callProperty;
        CallPropertyType[] oldValue = this._callProperties;
        this._callProperties = newCallProperties;
        this.firePropertyChange("callProperties", oldValue, this._callProperties);
    }

    public void removeCallProperty(CallPropertyType callProperty) {
        int existingCallPropertiesCnt = 0;
        if (this._callProperties != null) {
            existingCallPropertiesCnt = this._callProperties.length;
        }
        CallPropertyType[] newCallProperties = new CallPropertyType[existingCallPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingCallPropertiesCnt; ++n) {
            if (callProperty.equals(this._callProperties[n])) continue;
            newCallProperties[newIndex++] = this._callProperties[n];
        }
        if (newCallProperties.length == 0) {
            newCallProperties = null;
        }
        CallPropertyType[] oldValue = this._callProperties;
        this._callProperties = newCallProperties;
        this.firePropertyChange("callProperties", oldValue, this._callProperties);
    }

    public void setPortInfo(PortInfoType[] portInfo) {
        PortInfoType[] oldValue = this._portInfo;
        this._portInfo = portInfo;
        this.firePropertyChange("portInfo", oldValue, this._portInfo);
    }

    public PortInfoType[] getPortInfo() {
        return this._portInfo;
    }

    public PortInfoType[] defaultPortInfo() throws ConfigurationException {
        PortInfoType[] ret = new PortInfoType[]{new PortInfoType(this.getConfigParent())};
        return ret;
    }

    public void addPortInfo() throws ConfigurationException {
        if (this._portInfo != null) {
            return;
        }
        PortInfoType[] portInfo = new PortInfoType[]{new PortInfoType(this.getConfigParent(), null)};
        portInfo[0].addCallProperties();
        portInfo[0].addStubProperties();
        portInfo[0].setWsdlPort(portInfo[0].defaultWsdlPort());
        this.setPortInfo(portInfo);
    }

    public void removePortInfo() {
        if (this._portInfo == null) {
            return;
        }
        this.setPortInfo(null);
    }

    public void addPortInfo(PortInfoType portInfo) {
        portInfo.setParent(this.getConfigParent());
        int existingPortInfosCnt = 0;
        if (this._portInfo != null) {
            existingPortInfosCnt = this._portInfo.length;
        }
        PortInfoType[] newPortInfos = new PortInfoType[existingPortInfosCnt + 1];
        for (int n = 0; n < existingPortInfosCnt; ++n) {
            newPortInfos[n] = this._portInfo[n];
        }
        newPortInfos[existingPortInfosCnt] = portInfo;
        PortInfoType[] oldValue = this._portInfo;
        this._portInfo = newPortInfos;
        this.firePropertyChange("portInfo", oldValue, this._portInfo);
    }

    public void removePortInfo(PortInfoType portInfo) {
        int existingPortInfosCnt = 0;
        if (this._portInfo != null) {
            existingPortInfosCnt = this._portInfo.length;
        }
        PortInfoType[] newPortInfos = new PortInfoType[existingPortInfosCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPortInfosCnt; ++n) {
            if (portInfo.equals(this._portInfo[n])) continue;
            newPortInfos[newIndex++] = this._portInfo[n];
        }
        if (newPortInfos.length == 0) {
            newPortInfos = null;
        }
        PortInfoType[] oldValue = this._portInfo;
        this._portInfo = newPortInfos;
        this.firePropertyChange("portInfo", oldValue, this._portInfo);
    }
}

