/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.ServerOperationTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ServerOperationType;

public class ServerOperationsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_SERVER_OPERATION_MENU_STRING = "Add Server Operation";
    private JMenuItem _addServerOperationMenuItem;
    private ServerOperationType[] serverOperationsType = new ServerOperationType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public ServerOperationsTreeNode(ConfigTreeNode rootNode, MultipleType serverOperations) {
        super(serverOperations);
        this.setRootNode(rootNode);
        this._parentBean = serverOperations.getConfigParent();
        this._addServerOperationMenuItem = new JMenuItem(ADD_SERVER_OPERATION_MENU_STRING);
        this._addServerOperationMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addServerOperationMenuItem.setFont(ServerOperationsTreeNode.getFont());
        this._addServerOperationMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addServerOperationMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getServerOperations", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addServerOperation", ServerOperationType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeServerOperation", ServerOperationType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Server Operations";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            ServerOperationType[] serverOperations = (ServerOperationType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (serverOperations != null) {
                for (int i = 0; i < serverOperations.length; ++i) {
                    ServerOperationType serverOperation = serverOperations[i];
                    if (serverOperation == null) continue;
                    ServerOperationTreeNode serverOperationTreeNode = new ServerOperationTreeNode(this.getRootNode(), serverOperation);
                    this.addChild(serverOperationTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            ServerOperationType newServerOperation;
            if (event.getActionCommand().equals(ADD_SERVER_OPERATION_MENU_STRING) && this.showAddDialog(newServerOperation = new ServerOperationType(this._parentBean), ADD_SERVER_OPERATION_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newServerOperation);
                ServerOperationTreeNode newNode = new ServerOperationTreeNode(this, newServerOperation);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ServerOperationTreeNode) {
            try {
                ServerOperationType serverOperation = (ServerOperationType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, serverOperation);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

