/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.AuthConstraintType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.UserDataConstraintType;
import oracle.oc4j.admin.deploy.spi.xml.WebResourceCollectionType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityConstraintType
extends ConfigBeanNode {
    String displayName;
    WebResourceCollectionType[] webResourceCollections;
    AuthConstraintType authConstraint = null;
    UserDataConstraintType userDataConstraint = null;

    public SecurityConstraintType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("security-constraint");
        Vector<WebResourceCollectionType> resVec = new Vector<WebResourceCollectionType>();
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals("display-name")) {
                    this.displayName = XMLUtils.getValue(childNode);
                    continue;
                }
                if (nodeName.equals("web-resource-collection")) {
                    resVec.add(new WebResourceCollectionType(this, childNode));
                    continue;
                }
                if (nodeName.equals("auth-constraint")) {
                    this.authConstraint = new AuthConstraintType(this, childNode);
                    continue;
                }
                if (!nodeName.equals("user-data-constraint")) continue;
                this.userDataConstraint = new UserDataConstraintType(this, childNode);
            }
        }
        if (resVec.size() != 0) {
            this.webResourceCollections = resVec.toArray(new WebResourceCollectionType[0]);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "security-constraint");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "display-name", this.displayName);
        if (this.webResourceCollections != null && this.webResourceCollections.length != 0) {
            for (int i = 0; i < this.webResourceCollections.length; ++i) {
                this.webResourceCollections[i].writeXML(out, indentation + "\t");
            }
        }
        if (this.authConstraint != null) {
            this.authConstraint.writeXML(out, indentation + "\t");
        }
        if (this.userDataConstraint != null) {
            this.userDataConstraint.writeXML(out, indentation + "\t");
        }
        XMLUtils.writeTagEnd(out, indentation, "security-constraint");
    }

    public AuthConstraintType getAuthConstraint() {
        return this.authConstraint;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public UserDataConstraintType getUserDataConstraint() {
        return this.userDataConstraint;
    }

    public WebResourceCollectionType[] getWebResourceCollections() {
        return this.webResourceCollections;
    }
}

