/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SamlAuthorityConfigType
extends ConfigBeanNode {
    PropertyConfigBean[] _properties = null;
    String _endpointAddress = null;
    String _authUserName = null;
    String _authPassword = null;
    BooleanType _requireSignature = null;
    BooleanType _oldRequireSignature = null;

    public SamlAuthorityConfigType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public SamlAuthorityConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setProperties(PropertyConfigBean[] properties) throws ConfigurationException {
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        return new PropertyConfigBean[0];
    }

    public void addProperties() throws ConfigurationException {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() throws ConfigurationException {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) throws ConfigurationException {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) throws ConfigurationException {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void setEndpointAddress(String endpointAddress) {
        String oldValue = this._endpointAddress;
        this._endpointAddress = endpointAddress;
        this.firePropertyChange("endpointAddress", oldValue, this._endpointAddress);
    }

    public String getEndpointAddress() {
        return this._endpointAddress;
    }

    public String defaultEndpointAddress() {
        return "";
    }

    public void setAuthUserName(String authUserName) {
        String oldValue = this._authUserName;
        this._authUserName = authUserName;
        this.firePropertyChange("authUserName", oldValue, this._authUserName);
    }

    public String getAuthUserName() {
        return this._authUserName;
    }

    public String defaultAuthUserName() {
        return "";
    }

    public void setAuthPassword(String authPassword) {
        String oldValue = this._authPassword;
        this._authPassword = authPassword;
        this.firePropertyChange("authPassword", oldValue, this._authPassword);
    }

    public String getAuthPassword() {
        return this._authPassword;
    }

    public String defaultAuthPassword() {
        return "";
    }

    public void setRequireSignature(BooleanType requireSignature) throws ConfigurationException {
        this._requireSignature = requireSignature;
        this.firePropertyChange("requireSignature", this._oldRequireSignature, this._requireSignature);
        if (this._requireSignature != null) {
            if (this._oldRequireSignature == null) {
                this._oldRequireSignature = this.defaultRequireSignature();
            }
            this._oldRequireSignature.setValue(this._requireSignature.getValue());
        } else {
            this._oldRequireSignature = null;
        }
    }

    public BooleanType getRequireSignature() {
        return this._requireSignature;
    }

    public BooleanType defaultRequireSignature() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "saml-authority");
        if (this._endpointAddress != null && this._endpointAddress.length() > 0) {
            XMLUtils.writeAttribute(out, indentation, "endpoint-address", this._endpointAddress);
        }
        if (this._authUserName != null && this._authUserName.length() > 0) {
            XMLUtils.writeAttribute(out, indentation, "auth-user-name", this._authUserName);
        }
        if (this._authPassword != null && this._authPassword.length() > 0) {
            XMLUtils.writeAttribute(out, indentation, "auth-password", this._authPassword);
        }
        XMLUtils.writeAttribute(out, indentation, "require-signature", this._requireSignature);
        XMLUtils.writeTagAttributeEnd(out, indentation, "saml-authority");
        SamlAuthorityConfigType.writeXML(out, indentation + "\t", this._properties);
        XMLUtils.writeTagEnd(out, indentation, "saml-authority");
    }

    private void init() throws ConfigurationException {
        this.setXpath("saml-authority");
        Vector<PropertyConfigBean> properties = new Vector<PropertyConfigBean>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "endpoint-address");
            if (val != null && !val.trim().equals("")) {
                this._endpointAddress = val;
            }
            if ((val = XMLUtils.getAttribute(node, "auth-user-name")) != null && !val.trim().equals("")) {
                this._authUserName = val;
            }
            if ((val = XMLUtils.getAttribute(node, "auth-password")) != null && !val.trim().equals("")) {
                this._authPassword = val;
            }
            if ((val = XMLUtils.getAttribute(node, "require-signature")) != null && !val.trim().equals("")) {
                BooleanType requireSignature = this.defaultRequireSignature();
                requireSignature.setValue(val);
                this.setRequireSignature(requireSignature);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("property")) continue;
                PropertyConfigBean configBean = new PropertyConfigBean(this, node);
                properties.add(configBean);
            }
        }
        if (properties.size() > 0) {
            this.setProperties(properties.toArray(new PropertyConfigBean[0]));
        }
    }
}

