/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.model.DDBean;
import javax.swing.tree.TreePath;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTree;
import oracle.oc4j.admin.deploy.spi.xml.DataSourceLocationMappingType;
import oracle.oc4j.admin.deploy.spi.xml.JavaMailLocationMappingType;
import oracle.oc4j.admin.deploy.spi.xml.JmsQueueLocationMappingType;
import oracle.oc4j.admin.deploy.spi.xml.JmsTopicLocationMappingType;
import oracle.oc4j.admin.deploy.spi.xml.LocationMappingType;
import oracle.oc4j.admin.deploy.spi.xml.ResourceRefMappingTreeNode;
import org.w3c.dom.Node;

public class ResourceRefMappingConfigBean
extends ConfigBeanNode {
    String _name = null;
    LocationMappingType _locationMapping = null;

    public ResourceRefMappingConfigBean(DDBean stdBean, ConfigBeanNode parent, Node node) {
        super(stdBean, parent, node);
        this.init();
    }

    public ResourceRefMappingConfigBean(ConfigBeanNode parent, Node node) {
        this(null, parent, node);
    }

    public void putDDBean(DDBean bean) {
        super.putDDBean(bean);
        DDBean[] childBeans = bean.getChildBean("res-type");
        if (childBeans != null && childBeans[0] != null) {
            String text = childBeans[0].getText();
            String loc = this._locationMapping.getLocation();
            if ("javax.sql.DataSource".equals(text)) {
                this._locationMapping = new DataSourceLocationMappingType(this);
                this._locationMapping.setLocation(loc);
            } else if ("javax.mail.Session".equals(text)) {
                this._locationMapping = new JavaMailLocationMappingType(this);
                this._locationMapping.setLocation(loc);
            } else if ("javax.jms.Topic".equals(text)) {
                this._locationMapping = new JmsTopicLocationMappingType(this);
                this._locationMapping.setLocation(loc);
            } else if ("javax.jms.Queue".equals(text)) {
                this._locationMapping = new JmsQueueLocationMappingType(this);
                this._locationMapping.setLocation(loc);
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public String defaultName() {
        if (this._name != null) {
            return this._name;
        }
        return "";
    }

    public String key() {
        return this.getName();
    }

    public String beanKey() {
        return "res-ref-name";
    }

    public LocationMappingType getLocationMapping() {
        return this._locationMapping;
    }

    public LocationMappingType defaultLocationMapping() {
        return new LocationMappingType(this);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._locationMapping.getLocation() != null && this._locationMapping.getLocation().length() > 0) {
            XMLUtils.writeTagAttributeStart(out, indentation, "resource-ref-mapping");
            XMLUtils.writeAttribute(out, indentation, "name", this._name);
            XMLUtils.writeAttribute(out, indentation, "location", this._locationMapping.getLocation());
            XMLUtils.writeTagAttributeEnd(out, indentation, "resource-ref-mapping");
            XMLUtils.writeTagEnd(out, indentation, "resource-ref-mapping");
        }
    }

    private void init() {
        DDBean[] childBeans;
        this.setXpath("resource-ref-mapping");
        DDBean bean = this.getDDBean();
        if (bean != null && (childBeans = bean.getChildBean("res-type")) != null && childBeans[0] != null) {
            String text = childBeans[0].getText();
            if ("javax.sql.DataSource".equals(text)) {
                this._locationMapping = new DataSourceLocationMappingType(this);
            } else if ("javax.mail.Session".equals(text)) {
                this._locationMapping = new JavaMailLocationMappingType(this);
            } else if ("javax.jms.Topic".equals(text)) {
                this._locationMapping = new JmsTopicLocationMappingType(this);
            } else if ("javax.jms.Queue".equals(text)) {
                this._locationMapping = new JmsQueueLocationMappingType(this);
            }
        }
        if (this._locationMapping == null) {
            this._locationMapping = new LocationMappingType(this);
        }
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "name");
            if (val != null && !val.trim().equals("")) {
                this._name = val;
            }
            if ((val = XMLUtils.getAttribute(this.getNode(), "location")) != null && !val.trim().equals("")) {
                this._locationMapping.setLocation(val);
            }
        } else if (this.getDDBean() != null && this.getDDBean().getText(this.beanKey()) != null) {
            this._name = this.getDDBean().getText(this.beanKey())[0];
        }
    }

    public ViewableJTree[] subTrees() {
        ResourceRefMappingTreeNode treeNode = new ResourceRefMappingTreeNode(this);
        treeNode.setTreePath(new TreePath(treeNode));
        ConfigTree tree = new ConfigTree(treeNode);
        treeNode.setTree(tree);
        return new ViewableJTree[]{tree};
    }
}

