/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.ResourceProviderTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ResourceProviderType;

public class ResourceProvidersTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private Method _method;
    private static final String ADD_RESOURCE_PROVIDER_MENU_STRING = "Add Resource Provider";
    private JMenuItem _addResourceProviderMenuItem;
    private ResourceProviderType[] resourceProvidersType = new ResourceProviderType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public ResourceProvidersTreeNode(ConfigTreeNode rootNode, MultipleType providers) {
        super(providers);
        this.setRootNode(rootNode);
        this._parentBean = providers.getConfigParent();
        this._addResourceProviderMenuItem = new JMenuItem(ADD_RESOURCE_PROVIDER_MENU_STRING);
        this._addResourceProviderMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addResourceProviderMenuItem.setFont(ResourceProvidersTreeNode.getFont());
        this._addResourceProviderMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addResourceProviderMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getResourceProviders", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addResourceProvider", ResourceProviderType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeResourceProvider", ResourceProviderType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Resource Providers";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            ResourceProviderType[] resourceProviders = (ResourceProviderType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (resourceProviders != null) {
                for (int i = 0; i < resourceProviders.length; ++i) {
                    ResourceProviderType resourceProvider = resourceProviders[i];
                    if (resourceProvider == null) continue;
                    ResourceProviderTreeNode resourceProviderTreeNode = new ResourceProviderTreeNode(this.getRootNode(), resourceProvider);
                    this.addChild(resourceProviderTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            ResourceProviderType newResourceProvider;
            if (event.getActionCommand().equals(ADD_RESOURCE_PROVIDER_MENU_STRING) && this.showAddDialog(newResourceProvider = new ResourceProviderType(this._parentBean), ADD_RESOURCE_PROVIDER_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newResourceProvider);
                ResourceProviderTreeNode newNode = new ResourceProviderTreeNode(this, newResourceProvider);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ResourceProviderTreeNode) {
            try {
                ResourceProviderType resourceProvider = (ResourceProviderType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, resourceProvider);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

