/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ProviderPortType;
import oracle.oc4j.admin.deploy.spi.xml.ProviderPropertyType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProviderDescriptionConfigBean
extends ConfigBeanNode {
    protected String _providerDescriptionName = null;
    protected String _wsdlFile = null;
    protected String _wsdlServiceName = null;
    protected ProviderPortType[] _providerPorts = null;
    protected ProviderPropertyType[] _properties = null;

    public ProviderDescriptionConfigBean(DDBean stdBean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init();
    }

    public ProviderDescriptionConfigBean(ConfigBeanNode parent, Node node) throws ConfigurationException {
        this(null, parent, node);
    }

    public void setProviderDescriptionName(String providerDescriptionName) throws ConfigurationException {
        String oldValue = this._providerDescriptionName;
        this._providerDescriptionName = providerDescriptionName;
        this.firePropertyChange("providerDescriptionName", oldValue, this._providerDescriptionName);
    }

    public String getProviderDescriptionName() {
        return this._providerDescriptionName;
    }

    public String defaultProviderDescriptionName() {
        return "";
    }

    public void setWsdlFile(String wsdlFile) throws ConfigurationException {
        String oldValue = this._wsdlFile;
        this._wsdlFile = wsdlFile;
        this.firePropertyChange("wsdlFile", oldValue, this._wsdlFile);
    }

    public String getWsdlFile() {
        return this._wsdlFile;
    }

    public String defaultWsdlFile() {
        return "";
    }

    public void setWsdlServiceName(String wsdlServiceName) throws ConfigurationException {
        String oldValue = this._wsdlServiceName;
        this._wsdlServiceName = wsdlServiceName;
        this.firePropertyChange("wsdlServiceName", oldValue, this._wsdlServiceName);
    }

    public String getWsdlServiceName() {
        return this._wsdlServiceName;
    }

    public String defaultWsdlServiceName() {
        return "";
    }

    public void setProviderPorts(ProviderPortType[] providerPorts) throws ConfigurationException {
        ProviderPortType[] oldValue = this._providerPorts;
        this._providerPorts = providerPorts;
        this.firePropertyChange("providerPorts", oldValue, this._providerPorts);
    }

    public ProviderPortType[] getProviderPorts() {
        return this._providerPorts;
    }

    public ProviderPortType[] defaultProviderPorts() {
        try {
            return new ProviderPortType[0];
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addProviderPorts() throws ConfigurationException {
        if (this._providerPorts != null) {
            return;
        }
        ProviderPortType[] providerPorts = new ProviderPortType[]{new ProviderPortType(this, null)};
        this.setProviderPorts(providerPorts);
    }

    public void removeProviderPorts() throws ConfigurationException {
        if (this._providerPorts == null) {
            return;
        }
        this.setProviderPorts(null);
    }

    public void addProviderPort(ProviderPortType providerPort) throws ConfigurationException {
        providerPort.setParent(this);
        int existingProviderPortsCnt = 0;
        if (this._providerPorts != null) {
            existingProviderPortsCnt = this._providerPorts.length;
        }
        ProviderPortType[] newProviderPorts = new ProviderPortType[existingProviderPortsCnt + 1];
        for (int n = 0; n < existingProviderPortsCnt; ++n) {
            newProviderPorts[n] = this._providerPorts[n];
        }
        newProviderPorts[existingProviderPortsCnt] = providerPort;
        ProviderPortType[] oldValue = this._providerPorts;
        this._providerPorts = newProviderPorts;
        this.firePropertyChange("providerPorts", oldValue, this._providerPorts);
    }

    public void removeProviderPort(ProviderPortType providerPort) throws ConfigurationException {
        int existingProviderPortsCnt = 0;
        if (this._providerPorts != null) {
            existingProviderPortsCnt = this._providerPorts.length;
        }
        ProviderPortType[] newProviderPorts = new ProviderPortType[existingProviderPortsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingProviderPortsCnt; ++n) {
            if (providerPort.equals(this._providerPorts[n])) continue;
            newProviderPorts[newIndex++] = this._providerPorts[n];
        }
        if (newProviderPorts.length == 0) {
            newProviderPorts = null;
        }
        ProviderPortType[] oldValue = this._providerPorts;
        this._providerPorts = newProviderPorts;
        this.firePropertyChange("providerPorts", oldValue, this._providerPorts);
    }

    public void setProperties(ProviderPropertyType[] properties) throws ConfigurationException {
        ProviderPropertyType[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public ProviderPropertyType[] getProperties() {
        return this._properties;
    }

    public ProviderPropertyType[] defaultProperties() {
        return new ProviderPropertyType[0];
    }

    public void addProperties() throws ConfigurationException {
        if (this._properties != null) {
            return;
        }
        ProviderPropertyType[] properties = new ProviderPropertyType[]{new ProviderPropertyType(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() throws ConfigurationException {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(ProviderPropertyType property) throws ConfigurationException {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        ProviderPropertyType[] newProperties = new ProviderPropertyType[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        ProviderPropertyType[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(ProviderPropertyType property) throws ConfigurationException {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        ProviderPropertyType[] newProperties = new ProviderPropertyType[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        ProviderPropertyType[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "provider-description");
        XMLUtils.writeTagAttributeEnd(out, indentation, "provider-description");
        if (this._providerDescriptionName != null && this._providerDescriptionName.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "provider-description-name", this._providerDescriptionName);
        }
        if (this._wsdlFile != null && this._wsdlFile.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "wsdl-file", this._wsdlFile);
        }
        if (this._wsdlServiceName != null && this._wsdlServiceName.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "wsdl-service-name", this._wsdlServiceName);
        }
        ProviderDescriptionConfigBean.writeXML(out, indentation + "\t", this._providerPorts);
        ProviderDescriptionConfigBean.writeXML(out, indentation + "\t", this._properties);
        XMLUtils.writeTagEnd(out, indentation, "provider-description");
    }

    public void writeProviderPortsXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        ProviderPortType.writeXML(out, indentation, this._providerPorts);
    }

    public void writePropertiesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        ProviderPropertyType.writeXML(out, indentation, this._properties);
    }

    private void init() throws ConfigurationException {
        this.setXpath("provider-description");
        Vector<ProviderPortType> providerPorts = new Vector<ProviderPortType>();
        Vector<ProviderPropertyType> properties = new Vector<ProviderPropertyType>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("provider-description-name")) {
                    this.setProviderDescriptionName(XMLUtils.getValue(node));
                    continue;
                }
                if (name.equals("wsdl-file")) {
                    this.setWsdlFile(XMLUtils.getValue(node));
                    continue;
                }
                if (name.equals("wsdl-service-name")) {
                    this.setWsdlServiceName(XMLUtils.getValue(node));
                    continue;
                }
                if (name.equals("provider-port")) {
                    ProviderPortType providerPort = new ProviderPortType(this, node);
                    providerPorts.add(providerPort);
                    continue;
                }
                if (!name.equals("property")) continue;
                ProviderPropertyType configBean = new ProviderPropertyType(this, node);
                properties.add(configBean);
            }
        }
        if (providerPorts.size() > 0) {
            this.setProviderPorts(providerPorts.toArray(new ProviderPortType[0]));
        }
        if (properties.size() > 0) {
            this.setProperties(properties.toArray(new ProviderPropertyType[0]));
        }
    }
}

