/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.DatabaseTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.DatabaseType;
import oracle.oc4j.admin.deploy.spi.xml.MulticastTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MulticastType;
import oracle.oc4j.admin.deploy.spi.xml.PeerTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PeerType;
import oracle.oc4j.admin.deploy.spi.xml.ProtocolType;
import oracle.oc4j.admin.deploy.spi.xml.TunnelTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.TunnelType;

public class ProtocolTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ProtocolType _bean;
    private static final String ADD_MULTICAST_MENU_STRING = "Add Multicast";
    private static final String ADD_PEER_MENU_STRING = "Add Peer";
    private static final String ADD_TUNNEL_MENU_STRING = "Add Tunnel";
    private static final String ADD_DATABASE_MENU_STRING = "Add Database";
    private static final String REMOVE_PROTOCOL_MENU_STRING = "Remove Protocol";
    private JMenuItem _addMulticastMenuItem;
    private JMenuItem _addPeerMenuItem;
    private JMenuItem _addTunnelMenuItem;
    private JMenuItem _addDatabaseMenuItem;
    private JMenuItem _removeProtocolMenuItem;

    public ProtocolTreeNode(ConfigTreeNode rootNode, ProtocolType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addMulticastMenuItem = new JMenuItem(ADD_MULTICAST_MENU_STRING);
        this._addMulticastMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addMulticastMenuItem.setFont(ProtocolTreeNode.getFont());
        this._addMulticastMenuItem.addActionListener(this);
        if (this._bean.getMulticast() != null) {
            this._addMulticastMenuItem.setEnabled(false);
        } else if (this._bean.getTunnel() != null || this._bean.getPeer() != null) {
            this._addMulticastMenuItem.setEnabled(false);
        }
        this._addPeerMenuItem = new JMenuItem(ADD_PEER_MENU_STRING);
        this._addPeerMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPeerMenuItem.setFont(ProtocolTreeNode.getFont());
        this._addPeerMenuItem.addActionListener(this);
        if (this._bean.getPeer() != null) {
            this._addPeerMenuItem.setEnabled(false);
        } else if (this._bean.getTunnel() != null || this._bean.getMulticast() != null) {
            this._addPeerMenuItem.setEnabled(false);
        }
        this._addTunnelMenuItem = new JMenuItem(ADD_TUNNEL_MENU_STRING);
        this._addTunnelMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addTunnelMenuItem.setFont(ProtocolTreeNode.getFont());
        this._addTunnelMenuItem.addActionListener(this);
        if (this._bean.getTunnel() != null) {
            this._addTunnelMenuItem.setEnabled(false);
        } else if (this._bean.getPeer() != null || this._bean.getMulticast() != null) {
            this._addTunnelMenuItem.setEnabled(false);
        }
        this._addDatabaseMenuItem = new JMenuItem(ADD_DATABASE_MENU_STRING);
        this._addDatabaseMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addDatabaseMenuItem.setFont(ProtocolTreeNode.getFont());
        this._addDatabaseMenuItem.addActionListener(this);
        if (this._bean.getDatabase() != null) {
            this._addDatabaseMenuItem.setEnabled(false);
        }
        this._removeProtocolMenuItem = new JMenuItem(REMOVE_PROTOCOL_MENU_STRING);
        this._removeProtocolMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeProtocolMenuItem.setFont(ProtocolTreeNode.getFont());
        this._removeProtocolMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addMulticastMenuItem);
        this._popup.add(this._addPeerMenuItem);
        this._popup.add(this._addTunnelMenuItem);
        this._popup.add(this._addDatabaseMenuItem);
        this._popup.add(this._removeProtocolMenuItem);
    }

    public String viewHeaderString() {
        return "Protocol";
    }

    public String toString() {
        return "Protocol";
    }

    protected void buildChildJTree() {
        DatabaseType database;
        TunnelType tunnel;
        PeerType peer;
        MulticastType multicast = this._bean.getMulticast();
        if (multicast != null) {
            MulticastTreeNode multicastTreeNode = new MulticastTreeNode(this.getRootNode(), multicast);
            this.addChild(multicastTreeNode);
        }
        if ((peer = this._bean.getPeer()) != null) {
            PeerTreeNode peerTreeNode = new PeerTreeNode(this.getRootNode(), peer);
            this.addChild(peerTreeNode);
        }
        if ((tunnel = this._bean.getTunnel()) != null) {
            TunnelTreeNode tunnelTreeNode = new TunnelTreeNode(this.getRootNode(), tunnel);
            this.addChild(tunnelTreeNode);
        }
        if ((database = this._bean.getDatabase()) != null) {
            DatabaseTreeNode databaseTreeNode = new DatabaseTreeNode(this.getRootNode(), database);
            this.addChild(databaseTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_MULTICAST_MENU_STRING)) {
                MulticastType newMulticast = this._bean.defaultMulticast();
                if (this.showAddDialog(newMulticast, ADD_MULTICAST_MENU_STRING)) {
                    this._bean.setMulticast(newMulticast);
                    MulticastTreeNode newNode = new MulticastTreeNode(this, newMulticast);
                    this.insertNode(newNode);
                    this._addMulticastMenuItem.setEnabled(false);
                    this._addTunnelMenuItem.setEnabled(false);
                    this._addPeerMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_PEER_MENU_STRING)) {
                PeerType newPeer = this._bean.defaultPeer();
                if (this.showAddDialog(newPeer, ADD_PEER_MENU_STRING)) {
                    this._bean.setPeer(newPeer);
                    PeerTreeNode newNode = new PeerTreeNode(this, newPeer);
                    this.insertNode(newNode);
                    this._addMulticastMenuItem.setEnabled(false);
                    this._addTunnelMenuItem.setEnabled(false);
                    this._addPeerMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_TUNNEL_MENU_STRING)) {
                if (this._bean.getTunnel() == null) {
                    this._bean.addTunnel();
                    TunnelTreeNode newNode = new TunnelTreeNode(this, this._bean.getTunnel());
                    this.insertNode(newNode);
                    this._addMulticastMenuItem.setEnabled(false);
                    this._addTunnelMenuItem.setEnabled(false);
                    this._addPeerMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_DATABASE_MENU_STRING)) {
                DatabaseType newDatabase;
                if (this._bean.getDatabase() == null && this.showAddDialog(newDatabase = this._bean.defaultDatabase(), ADD_DATABASE_MENU_STRING)) {
                    this._bean.setDatabase(newDatabase);
                    DatabaseTreeNode newNode = new DatabaseTreeNode(this, newDatabase);
                    this.insertNode(newNode);
                    this._addDatabaseMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_PROTOCOL_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof MulticastTreeNode) {
            this._bean.removeMulticast();
            this.removeNode(node);
            if (this._bean.getTunnel() == null && this._bean.getPeer() == null) {
                this._addMulticastMenuItem.setEnabled(true);
                this._addTunnelMenuItem.setEnabled(true);
                this._addPeerMenuItem.setEnabled(true);
            }
        } else if (node instanceof PeerTreeNode) {
            this._bean.removePeer();
            this.removeNode(node);
            if (this._bean.getTunnel() == null && this._bean.getMulticast() == null) {
                this._addMulticastMenuItem.setEnabled(true);
                this._addTunnelMenuItem.setEnabled(true);
                this._addPeerMenuItem.setEnabled(true);
            }
        } else if (node instanceof TunnelTreeNode) {
            this._bean.removeTunnel();
            this.removeNode(node);
            if (this._bean.getPeer() == null && this._bean.getMulticast() == null) {
                this._addMulticastMenuItem.setEnabled(true);
                this._addTunnelMenuItem.setEnabled(true);
                this._addPeerMenuItem.setEnabled(true);
            }
        } else if (node instanceof DatabaseTreeNode) {
            this._bean.removeDatabase();
            this.removeNode(node);
            this._addDatabaseMenuItem.setEnabled(true);
        }
    }
}

