/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ImplementorType;
import oracle.oc4j.admin.deploy.spi.xml.ParamType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PortComponentImplementorType
extends ConfigBeanNode {
    protected ImplementorType _implementorType = this.defaultImplementorType();
    protected ParamType[] _params = null;

    public PortComponentImplementorType(ConfigBeanNode parent) {
        this(parent, null);
    }

    public PortComponentImplementorType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void setImplementorType(ImplementorType implementorType) {
        ImplementorType oldValue = this._implementorType;
        this._implementorType = implementorType;
        this.firePropertyChange("implementorType", oldValue, this._implementorType);
    }

    public ImplementorType getImplementorType() {
        return this._implementorType;
    }

    public ImplementorType defaultImplementorType() {
        return new ImplementorType(this);
    }

    public void setParams(ParamType[] params) {
        ParamType[] oldValue = this._params;
        this._params = params;
        this.firePropertyChange("params", oldValue, this._params);
    }

    public ParamType[] getParams() {
        return this._params;
    }

    public ParamType[] defaultParams() {
        return new ParamType[0];
    }

    public void addParams() {
        if (this._params != null) {
            return;
        }
        ParamType[] params = new ParamType[]{new ParamType(this, null)};
        this.setParams(params);
    }

    public void removeParams() {
        if (this._params == null) {
            return;
        }
        this.setParams(null);
    }

    public void addParam(ParamType param) {
        param.setParent(this);
        int existingParamsCnt = 0;
        if (this._params != null) {
            existingParamsCnt = this._params.length;
        }
        ParamType[] newParams = new ParamType[existingParamsCnt + 1];
        for (int n = 0; n < existingParamsCnt; ++n) {
            newParams[n] = this._params[n];
        }
        newParams[existingParamsCnt] = param;
        ParamType[] oldValue = this._params;
        this._params = newParams;
        this.firePropertyChange("params", oldValue, this._params);
    }

    public void removeParam(ParamType param) {
        int existingParamsCnt = 0;
        if (this._params != null) {
            existingParamsCnt = this._params.length;
        }
        ParamType[] newParams = new ParamType[existingParamsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingParamsCnt; ++n) {
            if (param.equals(this._params[n])) continue;
            newParams[newIndex++] = this._params[n];
        }
        if (newParams.length == 0) {
            newParams = null;
        }
        ParamType[] oldValue = this._params;
        this._params = newParams;
        this.firePropertyChange("params", oldValue, this._params);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "implementor");
        if (this._implementorType != null && this._implementorType.getValue() != null) {
            XMLUtils.writeAttribute(out, indentation, "type", this._implementorType.getValue());
        }
        XMLUtils.writeTagAttributeEnd(out, indentation, "implementor");
        ParamType.writeXML(out, indentation, this._params);
        XMLUtils.writeTagEnd(out, indentation, "implementor");
    }

    public void writeParamsXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        ParamType.writeXML(out, indentation, this._params);
    }

    private void init() {
        this.setXpath("implementor");
        Vector<ParamType> params = new Vector<ParamType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "type");
            if (val != null && !val.trim().equals("")) {
                this._implementorType = new ImplementorType(this);
                this._implementorType.setValue(val);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("param")) continue;
                ParamType arg = new ParamType(this, node);
                params.add(arg);
            }
        }
        if (params.size() > 0) {
            this.setParams(params.toArray(new ParamType[0]));
        }
    }
}

