/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PortComponentDeploymentType;
import oracle.oc4j.admin.deploy.spi.xml.ServiceQnameTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ServiceQnameType;

public class PortComponentDeploymentTreeNode
extends ConfigTreeNode
implements ActionListener {
    private PortComponentDeploymentType _bean;
    private static final String ADD_SERVICE_QNAME_MENU_STRING = "Add Service Qname";
    private static final String REMOVE_DEPLOYMENT_MENU_STRING = "Remove Deployment";
    private JMenuItem _addServiceQnameMenuItem;
    private JMenuItem _removeDeploymentMenuItem;

    public PortComponentDeploymentTreeNode(ConfigTreeNode rootNode, ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = (PortComponentDeploymentType)bean;
        this._addServiceQnameMenuItem = new JMenuItem(ADD_SERVICE_QNAME_MENU_STRING);
        this._addServiceQnameMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addServiceQnameMenuItem.setFont(PortComponentDeploymentTreeNode.getFont());
        this._addServiceQnameMenuItem.addActionListener(this);
        if (this._bean.getServiceQname() != null) {
            this._addServiceQnameMenuItem.setEnabled(false);
        }
        this._removeDeploymentMenuItem = new JMenuItem(REMOVE_DEPLOYMENT_MENU_STRING);
        this._removeDeploymentMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeDeploymentMenuItem.setFont(PortComponentDeploymentTreeNode.getFont());
        this._removeDeploymentMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addServiceQnameMenuItem);
        this._popup.add(this._removeDeploymentMenuItem);
    }

    public String viewHeaderString() {
        return "Deployment";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        ServiceQnameType serviceQname = this._bean.getServiceQname();
        if (serviceQname != null) {
            ServiceQnameTreeNode serviceQnameTreeNode = new ServiceQnameTreeNode(this.getRootNode(), serviceQname);
            this.addChild(serviceQnameTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_SERVICE_QNAME_MENU_STRING)) {
                ServiceQnameType newServiceQname = this._bean.defaultServiceQname();
                if (this.showAddDialog(newServiceQname, ADD_SERVICE_QNAME_MENU_STRING)) {
                    this._bean.setServiceQname(newServiceQname);
                    ServiceQnameTreeNode newNode = new ServiceQnameTreeNode(this, newServiceQname);
                    this.insertNode(newNode);
                    this._addServiceQnameMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_DEPLOYMENT_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ServiceQnameTreeNode) {
            this._bean.removeServiceQname();
            this.removeNode(node);
            this._addServiceQnameMenuItem.setEnabled(true);
        }
    }
}

