/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.NodeTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.NodeType;
import oracle.oc4j.admin.deploy.spi.xml.OpmnDiscoveryTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.OpmnDiscoveryType;
import oracle.oc4j.admin.deploy.spi.xml.PeerType;

public class PeerTreeNode
extends ConfigTreeNode
implements ActionListener {
    private PeerType _bean;
    private static final String ADD_NODE_MENU_STRING = "Add Node";
    private static final String ADD_OPMN_DISCOVERY_MENU_STRING = "Add Opmn Discovery";
    private static final String REMOVE_PEER_MENU_STRING = "Remove Peer";
    private JMenuItem _addNodeMenuItem;
    private JMenuItem _addOpmnDiscoveryMenuItem;
    private JMenuItem _removePeerMenuItem;

    public PeerTreeNode(ConfigTreeNode rootNode, PeerType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addNodeMenuItem = new JMenuItem(ADD_NODE_MENU_STRING);
        this._addNodeMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addNodeMenuItem.setFont(PeerTreeNode.getFont());
        this._addNodeMenuItem.addActionListener(this);
        if (this._bean.getOpmnDiscovery() != null) {
            this._addNodeMenuItem.setEnabled(false);
        }
        this._addOpmnDiscoveryMenuItem = new JMenuItem(ADD_OPMN_DISCOVERY_MENU_STRING);
        this._addOpmnDiscoveryMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addOpmnDiscoveryMenuItem.setFont(PeerTreeNode.getFont());
        this._addOpmnDiscoveryMenuItem.addActionListener(this);
        if (this._bean.getOpmnDiscovery() != null) {
            this._addOpmnDiscoveryMenuItem.setEnabled(false);
        } else if (this._bean.getNodes() != null && this._bean.getNodes().length > 0) {
            this._addOpmnDiscoveryMenuItem.setEnabled(false);
        }
        this._removePeerMenuItem = new JMenuItem(REMOVE_PEER_MENU_STRING);
        this._removePeerMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removePeerMenuItem.setFont(PeerTreeNode.getFont());
        this._removePeerMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addNodeMenuItem);
        this._popup.add(this._addOpmnDiscoveryMenuItem);
        this._popup.add(this._removePeerMenuItem);
    }

    public String viewHeaderString() {
        return "Peer";
    }

    public String toString() {
        return "Peer";
    }

    protected void buildChildJTree() {
        OpmnDiscoveryType opmnDiscovery;
        NodeType[] nodes = this._bean.getNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                NodeType node = nodes[i];
                if (node == null) continue;
                NodeTreeNode nodeTreeNode = new NodeTreeNode(this.getRootNode(), node);
                this.addChild(nodeTreeNode);
            }
        }
        if ((opmnDiscovery = this._bean.getOpmnDiscovery()) != null) {
            OpmnDiscoveryTreeNode opmnDiscoveryTreeNode = new OpmnDiscoveryTreeNode(this.getRootNode(), opmnDiscovery);
            this.addChild(opmnDiscoveryTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_NODE_MENU_STRING)) {
                NodeType newNode = new NodeType(this._bean);
                if (this.showAddDialog(newNode, ADD_NODE_MENU_STRING)) {
                    this._bean.addNode(newNode);
                    NodeTreeNode newTreeNode = new NodeTreeNode(this, newNode);
                    this.insertNode(newTreeNode);
                    this._addOpmnDiscoveryMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_OPMN_DISCOVERY_MENU_STRING)) {
                if (this._bean.getOpmnDiscovery() == null) {
                    this._bean.addOpmnDiscovery();
                    OpmnDiscoveryTreeNode newNode = new OpmnDiscoveryTreeNode(this, this._bean.getOpmnDiscovery());
                    this.insertNode(newNode);
                    this._addOpmnDiscoveryMenuItem.setEnabled(false);
                    this._addNodeMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_PEER_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode treeNode) throws ConfigurationException {
        if (treeNode instanceof NodeTreeNode) {
            NodeType node = (NodeType)treeNode.getConfigBeanNode();
            this._bean.removeNode(node);
            this.removeNode(treeNode);
            if (this._bean.getNodes() == null || this._bean.getNodes().length == 0) {
                this._addOpmnDiscoveryMenuItem.setEnabled(true);
            }
        } else if (treeNode instanceof OpmnDiscoveryTreeNode) {
            this._bean.removeOpmnDiscovery();
            this.removeNode(treeNode);
            this._addOpmnDiscoveryMenuItem.setEnabled(true);
            this._addNodeMenuItem.setEnabled(true);
        }
    }
}

