/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.PasswordCredentialTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PasswordCredentialType;

public class PasswordCredentialsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_PASSWORD_CREDENTIAL_MENU_STRING = "Add Password Credential";
    private JMenuItem _addPasswordCredentialMenuItem;
    private PasswordCredentialType[] passwordCredentialsType = new PasswordCredentialType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public PasswordCredentialsTreeNode(ConfigTreeNode rootNode, MultipleType passwordCredentials) {
        super(passwordCredentials);
        this.setRootNode(rootNode);
        this._parentBean = passwordCredentials.getConfigParent();
        this._addPasswordCredentialMenuItem = new JMenuItem(ADD_PASSWORD_CREDENTIAL_MENU_STRING);
        this._addPasswordCredentialMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPasswordCredentialMenuItem.setFont(PasswordCredentialsTreeNode.getFont());
        this._addPasswordCredentialMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addPasswordCredentialMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getPasswordCredentials", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addPasswordCredential", PasswordCredentialType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removePasswordCredential", PasswordCredentialType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Password Credentials";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            PasswordCredentialType[] passwordCredentials = (PasswordCredentialType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (passwordCredentials != null) {
                for (int i = 0; i < passwordCredentials.length; ++i) {
                    PasswordCredentialType passwordCredential = passwordCredentials[i];
                    if (passwordCredential == null) continue;
                    PasswordCredentialTreeNode passwordCredentialTreeNode = new PasswordCredentialTreeNode(this.getRootNode(), passwordCredential);
                    this.addChild(passwordCredentialTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            PasswordCredentialType newPasswordCredential;
            if (event.getActionCommand().equals(ADD_PASSWORD_CREDENTIAL_MENU_STRING) && this.showAddDialog(newPasswordCredential = new PasswordCredentialType(this._parentBean), ADD_PASSWORD_CREDENTIAL_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newPasswordCredential);
                PasswordCredentialTreeNode newNode = new PasswordCredentialTreeNode(this, newPasswordCredential);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof PasswordCredentialTreeNode) {
            try {
                PasswordCredentialType passwordCredential = (PasswordCredentialType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, passwordCredential);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

