/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PasswordCredentialType
extends ConfigBeanNode {
    String _username = null;
    String _password = null;

    public PasswordCredentialType(ConfigBeanNode parent) {
        this(parent, null);
    }

    public PasswordCredentialType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void setUsername(String username) {
        String oldValue = this._username;
        this._username = username;
        this.firePropertyChange("username", oldValue, this._username);
    }

    public String getUsername() {
        return this._username;
    }

    public String defaultUsername() {
        return "";
    }

    public void setPassword(String password) {
        String oldValue = this._password;
        this._password = password;
        this.firePropertyChange("password", oldValue, this._password);
    }

    public String getPassword() {
        return this._password;
    }

    public String defaultPassword() {
        return "";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "password-credential");
        XMLUtils.writeTagAttributeEnd(out, indentation, "password-credential");
        if (this._username != null && this._username.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "username", this._username);
            XMLUtils.writeTag(out, indentation + "\t", "password", this._password);
        }
        XMLUtils.writeTagEnd(out, indentation, "password-credential");
    }

    public static void writeXML(PrintWriter out, String indentation, PasswordCredentialType[] passwordCredentials) throws ExtendedRuntimeException {
        if (passwordCredentials == null) {
            return;
        }
        for (int n = 0; n < passwordCredentials.length; ++n) {
            passwordCredentials[n].writeXML(out, indentation);
        }
    }

    private void init() {
        this.setXpath("password-credential");
        Vector properties = new Vector();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("username")) {
                    this._username = XMLUtils.getValue(node);
                }
                if (!name.equals("password")) continue;
                this._password = XMLUtils.getValue(node);
            }
        }
    }
}

