/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.KeyTransportMethodConfigType;
import oracle.oc4j.admin.deploy.spi.xml.KeyTransportMethodTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.KeyTransportMethodsConfigType;

public class KeyTransportMethodsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private KeyTransportMethodsConfigType _bean;
    private static final String ADD_KEY_TRANSPORT_METHOD_MENU_STRING = "Add Key Transport Method";
    private static final String REMOVE_KEY_TRANSPORT_METHODS_MENU_STRING = "Remove Key Transport Methods";
    private JMenuItem _addKeyTransportMethodMenuItem;
    private JMenuItem _removeKeyTransportMethodsMenuItem;

    public KeyTransportMethodsTreeNode(ConfigTreeNode rootNode, KeyTransportMethodsConfigType keyTransportMethods) {
        super(keyTransportMethods);
        this.setRootNode(rootNode);
        this._bean = keyTransportMethods;
        this._addKeyTransportMethodMenuItem = new JMenuItem(ADD_KEY_TRANSPORT_METHOD_MENU_STRING);
        this._addKeyTransportMethodMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addKeyTransportMethodMenuItem.setFont(KeyTransportMethodsTreeNode.getFont());
        this._addKeyTransportMethodMenuItem.addActionListener(this);
        this._removeKeyTransportMethodsMenuItem = new JMenuItem(REMOVE_KEY_TRANSPORT_METHODS_MENU_STRING);
        this._removeKeyTransportMethodsMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeKeyTransportMethodsMenuItem.setFont(KeyTransportMethodsTreeNode.getFont());
        this._removeKeyTransportMethodsMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addKeyTransportMethodMenuItem);
        this._popup.add(this._removeKeyTransportMethodsMenuItem);
    }

    public String viewHeaderString() {
        return "KeyTransport Methods";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        KeyTransportMethodConfigType[] keyTransportMethods = this._bean.getKeyTransportMethods();
        if (keyTransportMethods != null) {
            for (int i = 0; i < keyTransportMethods.length; ++i) {
                KeyTransportMethodConfigType keyTransportMethod = keyTransportMethods[i];
                if (keyTransportMethod == null) continue;
                KeyTransportMethodTreeNode keyTransportMethodTreeNode = new KeyTransportMethodTreeNode(this.getRootNode(), keyTransportMethod);
                this.addChild(keyTransportMethodTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_KEY_TRANSPORT_METHOD_MENU_STRING)) {
                KeyTransportMethodConfigType newKeyTransportMethod = new KeyTransportMethodConfigType(this._bean);
                if (this.showAddDialog(newKeyTransportMethod, ADD_KEY_TRANSPORT_METHOD_MENU_STRING)) {
                    this._bean.addKeyTransportMethod(newKeyTransportMethod);
                    KeyTransportMethodTreeNode newNode = new KeyTransportMethodTreeNode(this, newKeyTransportMethod);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(REMOVE_KEY_TRANSPORT_METHODS_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof KeyTransportMethodTreeNode) {
            KeyTransportMethodConfigType keyTransportMethod = (KeyTransportMethodConfigType)node.getConfigBeanNode();
            this._bean.removeKeyTransportMethod(keyTransportMethod);
            this.removeNode(node);
        }
    }
}

