/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaznWebAppType
extends ConfigBeanNode {
    String _authMethod = null;
    BooleanType _runAsMode = null;
    BooleanType _oldRunAsMode = null;
    BooleanType _doAsPrivilegedMode = null;
    BooleanType _oldDoAsPrivilegedMode = null;
    PropertyConfigBean[] _properties = null;

    public JaznWebAppType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setAuthMethod(String authMethod) throws ConfigurationException {
        String oldValue = this._authMethod;
        this._authMethod = authMethod;
        this.firePropertyChange("authMethod", oldValue, this._authMethod);
    }

    public String getAuthMethod() {
        return this._authMethod;
    }

    public String defaultAuthMethod() {
        return "";
    }

    public void setRunAsMode(BooleanType runAsMode) throws ConfigurationException {
        this._runAsMode = runAsMode;
        this.firePropertyChange("runAsMode", this._oldRunAsMode, this._runAsMode);
        if (this._runAsMode != null) {
            if (this._oldRunAsMode == null) {
                this._oldRunAsMode = this.defaultRunAsMode();
            }
            this._oldRunAsMode.setValue(this._runAsMode.getValue());
        } else {
            this._oldRunAsMode = null;
        }
    }

    public BooleanType getRunAsMode() {
        return this._runAsMode;
    }

    public BooleanType defaultRunAsMode() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setDoAsPrivilegedMode(BooleanType doAsPrivilegedMode) throws ConfigurationException {
        this._doAsPrivilegedMode = doAsPrivilegedMode;
        this.firePropertyChange("doAsPrivilegedMode", this._oldDoAsPrivilegedMode, this._doAsPrivilegedMode);
        if (this._doAsPrivilegedMode != null) {
            if (this._oldDoAsPrivilegedMode == null) {
                this._oldDoAsPrivilegedMode = this.defaultDoAsPrivilegedMode();
            }
            this._oldDoAsPrivilegedMode.setValue(this._doAsPrivilegedMode.getValue());
        } else {
            this._oldDoAsPrivilegedMode = null;
        }
    }

    public BooleanType getDoAsPrivilegedMode() {
        return this._doAsPrivilegedMode;
    }

    public BooleanType defaultDoAsPrivilegedMode() {
        try {
            return new BooleanType(this, "true");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setProperties(PropertyConfigBean[] properties) throws ConfigurationException {
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        return new PropertyConfigBean[0];
    }

    public void addProperties() throws ConfigurationException {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() throws ConfigurationException {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) throws ConfigurationException {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) throws ConfigurationException {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "jazn-web-app");
        XMLUtils.writeAttribute(out, indentation, "auth-method", this._authMethod);
        XMLUtils.writeAttribute(out, indentation, "runas-mode", this._runAsMode);
        XMLUtils.writeAttribute(out, indentation, "doasprivileged-mode", this._doAsPrivilegedMode);
        XMLUtils.writeTagAttributeEnd(out, indentation, "jazn-web-app");
        JaznWebAppType.writeXML(out, indentation + "\t", this._properties);
        XMLUtils.writeTagEnd(out, indentation, "jazn-web-app");
    }

    private void init() throws ConfigurationException {
        this.setXpath("jazn-web-app");
        Vector<PropertyConfigBean> properties = new Vector<PropertyConfigBean>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "auth-method");
            if (val != null && !val.trim().equals("")) {
                this.setAuthMethod(val);
            }
            if ((val = XMLUtils.getAttribute(node, "runas-mode")) != null && !val.trim().equals("")) {
                BooleanType runAsMode = this.defaultRunAsMode();
                runAsMode.setValue(val);
                this.setRunAsMode(runAsMode);
            }
            if ((val = XMLUtils.getAttribute(node, "doasprivileged-mode")) != null && !val.trim().equals("")) {
                BooleanType doAsPrivilegedMode = this.defaultDoAsPrivilegedMode();
                doAsPrivilegedMode.setValue(val);
                this.setDoAsPrivilegedMode(doAsPrivilegedMode);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("property")) continue;
                PropertyConfigBean configBean = new PropertyConfigBean(this, node);
                properties.add(configBean);
            }
        }
        if (properties.size() > 0) {
            this.setProperties(properties.toArray(new PropertyConfigBean[0]));
        }
    }
}

