/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.JaznWebAppType;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.PropertyTreeNode;

public class JaznWebAppTreeNode
extends ConfigTreeNode
implements ActionListener {
    private JaznWebAppType _bean;
    private static final String ADD_PROPERTY_MENU_STRING = "Add Property";
    private static final String REMOVE_JAZN_WEB_APP_MENU_STRING = "Remove Jazn Web App";
    private JMenuItem _addPropertyMenuItem;
    private JMenuItem _removeJaznWebAppMenuItem;

    public JaznWebAppTreeNode(ConfigTreeNode rootNode, JaznWebAppType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addPropertyMenuItem = new JMenuItem(ADD_PROPERTY_MENU_STRING);
        this._addPropertyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPropertyMenuItem.setFont(JaznWebAppTreeNode.getFont());
        this._addPropertyMenuItem.addActionListener(this);
        this._removeJaznWebAppMenuItem = new JMenuItem(REMOVE_JAZN_WEB_APP_MENU_STRING);
        this._removeJaznWebAppMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeJaznWebAppMenuItem.setFont(JaznWebAppTreeNode.getFont());
        this._removeJaznWebAppMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addPropertyMenuItem);
        this._popup.add(this._removeJaznWebAppMenuItem);
    }

    public String viewHeaderString() {
        return "Jazn Web App";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        PropertyConfigBean[] properties = this._bean.getProperties();
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                PropertyConfigBean property = properties[i];
                if (property == null) continue;
                PropertyTreeNode propertyTreeNode = new PropertyTreeNode(this.getRootNode(), property);
                this.addChild(propertyTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_PROPERTY_MENU_STRING)) {
                PropertyConfigBean newProperty = new PropertyConfigBean(this._bean);
                if (this.showAddDialog(newProperty, ADD_PROPERTY_MENU_STRING)) {
                    this._bean.addProperty(newProperty);
                    PropertyTreeNode newNode = new PropertyTreeNode(this, newProperty);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(REMOVE_JAZN_WEB_APP_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof PropertyTreeNode) {
            PropertyConfigBean property = (PropertyConfigBean)node.getConfigBeanNode();
            this._bean.removeProperty(property);
            this.removeNode(node);
        }
    }
}

