/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.File;
import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.JaznWebAppType;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaznConfigBean
extends ConfigBeanNode {
    public static final String XML_PROVIDER = "XML";
    public static final String LDAP_PROVIDER = "LDAP";
    public static final String CUSTOM_LDAP_PROVIDER = "CUSTOM_LDAP";
    public static final String CUSTOM_LOGIN_MODULE_PROVIDER = "CUSTOM_LOGIN_MODULE";
    public static final String CUSTOM_LDAP_PROVIDER_NAME = "custom.ldap.provider";
    public static final String CUSTOM_LOGIN_MODULE_PROVIDER_NAME = "custom.loginmodule.provider";
    public static final String ROLE_MAPPING_DYNAMIC_NAME = "role.mapping.dynamic";
    StringType _provider = null;
    StringType _oldProvider = null;
    String _location = null;
    String _defaultRealm = null;
    StringType _persistence = null;
    StringType _oldPersistence = null;
    JaznWebAppType _jaznWebApp = null;
    PropertyConfigBean[] _properties = null;
    Vector _newProperties = null;
    StringType _jaasMode = null;
    StringType _oldJaasMode = null;

    public JaznConfigBean(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setProvider(StringType provider) throws ConfigurationException {
        this._provider = provider;
        this.firePropertyChange("provider", this._oldProvider, this._provider);
        if (this._provider != null) {
            if (this._oldProvider == null || !this._oldProvider.getValue().equals(this._provider.getValue())) {
                this._newProperties = new Vector();
            } else {
                this.cloneProperties();
            }
            if (LDAP_PROVIDER.equals(this._provider.getValue()) || CUSTOM_LDAP_PROVIDER.equals(this._provider.getValue()) || CUSTOM_LOGIN_MODULE_PROVIDER.equals(this._provider.getValue())) {
                this.setLocation("");
                this.setDefaultRealm("");
            }
            if (CUSTOM_LDAP_PROVIDER.equals(this._provider.getValue())) {
                this.putProperty(CUSTOM_LDAP_PROVIDER_NAME, "true");
            }
            if (CUSTOM_LOGIN_MODULE_PROVIDER.equals(this._provider.getValue())) {
                this.putProperty(CUSTOM_LOGIN_MODULE_PROVIDER_NAME, "true");
                this.putProperty(ROLE_MAPPING_DYNAMIC_NAME, "true");
            }
            if (this._newProperties.size() > 0) {
                this.setProperties(this._newProperties.toArray(new PropertyConfigBean[0]));
            } else {
                this.removeProperties();
            }
            if (this._oldProvider == null) {
                this._oldProvider = this.defaultProvider();
            }
            this._oldProvider.setValue(this._provider.getValue());
        } else {
            this.setProperties(null);
            this._oldProvider = null;
        }
    }

    public StringType getProvider() {
        return this._provider;
    }

    public StringType defaultProvider() {
        String[] tags = new String[]{XML_PROVIDER, LDAP_PROVIDER, CUSTOM_LDAP_PROVIDER, CUSTOM_LOGIN_MODULE_PROVIDER};
        return new StringType(this, tags, XML_PROVIDER);
    }

    public void setLocation(String location) throws ConfigurationException {
        String oldValue = this._location;
        if (location != null && location.length() > 0) {
            String dotslash = "." + File.separatorChar;
            while (location.indexOf(dotslash) == 0) {
                location = location.substring(2);
            }
            while (location.indexOf("./") == 0) {
                location = location.substring(2);
            }
        }
        this._location = location;
        this.firePropertyChange("location", oldValue, this._location);
        this.determineRoot().initJaznDataFromEntry(location);
    }

    public String getLocation() {
        return this._location;
    }

    public String defaultLocation() {
        return "";
    }

    public void setDefaultRealm(String defaultRealm) throws ConfigurationException {
        String oldValue = this._defaultRealm;
        this._defaultRealm = defaultRealm;
        this.firePropertyChange("defaultRealm", oldValue, this._defaultRealm);
    }

    public String getDefaultRealm() {
        String defaultRealmName;
        if (this._defaultRealm != null && this._defaultRealm.length() > 0) {
            return this._defaultRealm;
        }
        if (this._provider != null && XML_PROVIDER.equals(this._provider.getValue()) && (defaultRealmName = this.determineRoot().getDefaultRealm()) != null) {
            return defaultRealmName;
        }
        return "";
    }

    public String defaultDefaultRealm() {
        return "jazn.com";
    }

    public void setPersistence(StringType persistence) throws ConfigurationException {
        this._persistence = persistence;
        if (this._persistence != null) {
            this._persistence.setParent(this);
        }
        this.firePropertyChange("persistence", this._oldPersistence, this._persistence);
        if (this._persistence != null) {
            if (this._oldPersistence == null) {
                this._oldPersistence = this.defaultPersistence();
            }
            this._oldPersistence.setValue(this._persistence.getValue());
        } else {
            this._oldPersistence = null;
        }
    }

    public StringType getPersistence() {
        return this._persistence;
    }

    public StringType defaultPersistence() {
        String[] tags = new String[]{"NONE", "ALL", "VM_EXIT"};
        return new StringType(this, tags, "NONE");
    }

    public void setJaznWebApp(JaznWebAppType jaznWebApp) throws ConfigurationException {
        JaznWebAppType oldValue = this._jaznWebApp;
        this._jaznWebApp = jaznWebApp;
        this.firePropertyChange("jaznWebApp", oldValue, this._jaznWebApp);
    }

    public JaznWebAppType getJaznWebApp() {
        return this._jaznWebApp;
    }

    public JaznWebAppType defaultJaznWebApp() {
        try {
            return new JaznWebAppType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addJaznWebApp() throws ConfigurationException {
        if (this._jaznWebApp != null) {
            return;
        }
        JaznWebAppType jaznWebApp = new JaznWebAppType(this, null);
        this.setJaznWebApp(jaznWebApp);
    }

    public void removeJaznWebApp() throws ConfigurationException {
        if (this._jaznWebApp == null) {
            return;
        }
        this.setJaznWebApp(null);
    }

    public void setProperties(PropertyConfigBean[] properties) throws ConfigurationException {
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        return new PropertyConfigBean[0];
    }

    public void addProperties() throws ConfigurationException {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() throws ConfigurationException {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) throws ConfigurationException {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) throws ConfigurationException {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    private boolean hasProperty(String name) {
        if (this._properties != null && name != null) {
            for (int n = 0; n < this._properties.length; ++n) {
                if (!name.equals(this._properties[n].getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void cloneProperties() {
        this._newProperties = new Vector();
        for (int n = 0; n < this._properties.length; ++n) {
            PropertyConfigBean newBean = new PropertyConfigBean(this);
            newBean.setName(this._properties[n].getName());
            newBean.setValue(this._properties[n].getValue());
            this._newProperties.add(newBean);
        }
    }

    private void putProperty(String name, String value) throws ConfigurationException {
        PropertyConfigBean propertyBean = null;
        if (this._newProperties != null) {
            for (int n = 0; n < this._newProperties.size(); ++n) {
                if (!name.equals(((PropertyConfigBean)this._newProperties.elementAt(n)).getName())) continue;
                propertyBean = (PropertyConfigBean)this._newProperties.elementAt(n);
                break;
            }
        }
        if (propertyBean != null) {
            if (propertyBean.getValue() == null || !value.equals(propertyBean.getValue())) {
                propertyBean.setValue(value);
            }
            return;
        }
        propertyBean = new PropertyConfigBean(this);
        propertyBean.setName(name);
        propertyBean.setValue(value);
        this._newProperties.add(propertyBean);
    }

    public void setJaasMode(StringType jaasMode) throws ConfigurationException {
        this._jaasMode = jaasMode;
        if (this._jaasMode != null) {
            this._jaasMode.setParent(this);
        }
        this.firePropertyChange("jaasMode", this._oldJaasMode, this._jaasMode);
        if (this._jaasMode != null) {
            if (this._oldJaasMode == null) {
                this._oldJaasMode = this.defaultJaasMode();
            }
            this._oldJaasMode.setValue(this._jaasMode.getValue());
        } else {
            this._oldJaasMode = null;
        }
    }

    public StringType getJaasMode() {
        return this._jaasMode;
    }

    public StringType defaultJaasMode() {
        String[] tags = new String[]{"", "doAs", "doAsPrivileged"};
        return new StringType(this, tags, "");
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "jazn");
        if (this._provider != null && (CUSTOM_LDAP_PROVIDER.equals(this._provider.getValue()) || CUSTOM_LOGIN_MODULE_PROVIDER.equals(this._provider.getValue()))) {
            XMLUtils.writeAttribute(out, indentation, "provider", XML_PROVIDER);
        } else {
            XMLUtils.writeAttribute(out, indentation, "provider", this._provider);
        }
        XMLUtils.writeAttribute(out, indentation, "location", this._location);
        XMLUtils.writeAttribute(out, indentation, "default-realm", this.getDefaultRealm());
        XMLUtils.writeAttribute(out, indentation, "persistence", this._persistence);
        XMLUtils.writeAttribute(out, indentation, "jaas-mode", this._jaasMode);
        XMLUtils.writeTagAttributeEnd(out, indentation, "jazn");
        if (this._jaznWebApp != null) {
            this._jaznWebApp.writeXML(out, indentation + "\t");
        }
        JaznConfigBean.writeXML(out, indentation + "\t", this._properties);
        XMLUtils.writeTagEnd(out, indentation, "jazn");
    }

    private void init() throws ConfigurationException {
        this.setXpath("jazn");
        this._newProperties = new Vector();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "location");
            if (val != null && !val.trim().equals("")) {
                this.setLocation(val);
            }
            if ((val = XMLUtils.getAttribute(node, "default-realm")) != null && !val.trim().equals("")) {
                this.setDefaultRealm(val);
            }
            if ((val = XMLUtils.getAttribute(node, "persistence")) != null && !val.trim().equals("")) {
                StringType persistence = this.defaultPersistence();
                persistence.setValue(val);
                this.setPersistence(persistence);
            }
            if ((val = XMLUtils.getAttribute(node, "provider")) != null && !val.trim().equals("")) {
                StringType provider = this.defaultProvider();
                provider.setValue(val);
                this.setProvider(provider);
            }
            if ((val = XMLUtils.getAttribute(node, "jaas-mode")) != null && !val.trim().equals("")) {
                StringType jaasMode = this.defaultJaasMode();
                jaasMode.setValue(val);
                this.setJaasMode(jaasMode);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("property")) {
                    StringType provider;
                    PropertyConfigBean configBean = new PropertyConfigBean(this, node);
                    if (CUSTOM_LDAP_PROVIDER_NAME.equals(configBean.getName())) {
                        if (this._provider != null && XML_PROVIDER.equals(this._provider.getValue())) {
                            provider = this.defaultProvider();
                            provider.setValue(CUSTOM_LDAP_PROVIDER);
                            this.setProvider(provider);
                        }
                    } else if (CUSTOM_LOGIN_MODULE_PROVIDER_NAME.equals(configBean.getName())) {
                        if (this._provider != null && XML_PROVIDER.equals(this._provider.getValue())) {
                            provider = this.defaultProvider();
                            provider.setValue(CUSTOM_LOGIN_MODULE_PROVIDER);
                            this.setProvider(provider);
                        }
                    } else {
                        this.putProperty(configBean.getName(), configBean.getValue());
                    }
                }
                if (!name.equals("jazn-web-app")) continue;
                this.setJaznWebApp(new JaznWebAppType(this, node));
            }
        }
        if (this._newProperties.size() > 0) {
            this.setProperties(this._newProperties.toArray(new PropertyConfigBean[0]));
        }
    }
}

