/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.IorSecurityConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.IorSecurityConfigType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class IorSecurityConfigsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_IOR_SECURITY_CONFIG_MENU_STRING = "Add Ior Security Config";
    private JMenuItem _addIorSecurityConfigMenuItem;
    private IorSecurityConfigType[] iorSecurityConfigsType = new IorSecurityConfigType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public IorSecurityConfigsTreeNode(ConfigTreeNode rootNode, MultipleType iorSecurityConfigs) {
        super(iorSecurityConfigs);
        this.setRootNode(rootNode);
        this._parentBean = iorSecurityConfigs.getConfigParent();
        this._addIorSecurityConfigMenuItem = new JMenuItem(ADD_IOR_SECURITY_CONFIG_MENU_STRING);
        this._addIorSecurityConfigMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addIorSecurityConfigMenuItem.setFont(IorSecurityConfigsTreeNode.getFont());
        this._addIorSecurityConfigMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addIorSecurityConfigMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getIorSecurityConfigs", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addIorSecurityConfig", IorSecurityConfigType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeIorSecurityConfig", IorSecurityConfigType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Ior Security Configs";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            IorSecurityConfigType[] iorSecurityConfigs = (IorSecurityConfigType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (iorSecurityConfigs != null) {
                for (int i = 0; i < iorSecurityConfigs.length; ++i) {
                    IorSecurityConfigType iorSecurityConfig = iorSecurityConfigs[i];
                    if (iorSecurityConfig == null) continue;
                    IorSecurityConfigTreeNode iorSecurityConfigTreeNode = new IorSecurityConfigTreeNode(this.getRootNode(), iorSecurityConfig);
                    this.addChild(iorSecurityConfigTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_IOR_SECURITY_CONFIG_MENU_STRING)) {
                IorSecurityConfigType newIorSecurityConfig = new IorSecurityConfigType(this._parentBean);
                if (this.confirm(ADD_IOR_SECURITY_CONFIG_MENU_STRING)) {
                    this._addMethod.invoke((Object)this._parentBean, newIorSecurityConfig);
                    IorSecurityConfigTreeNode newNode = new IorSecurityConfigTreeNode(this, newIorSecurityConfig);
                    this.insertNode(newNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof IorSecurityConfigTreeNode) {
            try {
                IorSecurityConfigType iorSecurityConfig = (IorSecurityConfigType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, iorSecurityConfig);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

