/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.InitParamTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.InitParamType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class InitParamsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_INIT_PARAM_MENU_STRING = "Add Init Param";
    private JMenuItem _addInitParamMenuItem;
    private InitParamType[] initParamsType = new InitParamType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public InitParamsTreeNode(ConfigTreeNode rootNode, MultipleType initParams) {
        super(initParams);
        this.setRootNode(rootNode);
        this._parentBean = initParams.getConfigParent();
        this._addInitParamMenuItem = new JMenuItem(ADD_INIT_PARAM_MENU_STRING);
        this._addInitParamMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addInitParamMenuItem.setFont(InitParamsTreeNode.getFont());
        this._addInitParamMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addInitParamMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getInitParams", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addInitParam", InitParamType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeInitParam", InitParamType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Init Params";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            InitParamType[] initParams = (InitParamType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (initParams != null) {
                for (int i = 0; i < initParams.length; ++i) {
                    InitParamType initParam = initParams[i];
                    if (initParam == null) continue;
                    InitParamTreeNode initParamTreeNode = new InitParamTreeNode(this.getRootNode(), initParam);
                    this.addChild(initParamTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            InitParamType newInitParam;
            if (event.getActionCommand().equals(ADD_INIT_PARAM_MENU_STRING) && this.showAddDialog(newInitParam = new InitParamType(this._parentBean), ADD_INIT_PARAM_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newInitParam);
                InitParamTreeNode newNode = new InitParamTreeNode(this, newInitParam);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof InitParamTreeNode) {
            try {
                InitParamType initParam = (InitParamType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, initParam);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

