/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ImportOrRemoveType;
import oracle.oc4j.admin.deploy.spi.xml.ImportType;
import oracle.oc4j.admin.deploy.spi.xml.RemoveType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportedLibrariesType
extends ConfigBeanNode {
    ImportOrRemoveType[] _libraries = null;

    public ImportedLibrariesType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public ImportedLibrariesType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setLibraries(ImportOrRemoveType[] libraries) throws ConfigurationException {
        ImportOrRemoveType[] oldValue = this._libraries;
        this._libraries = libraries;
        this.firePropertyChange("libraries", oldValue, this._libraries);
    }

    public ImportOrRemoveType[] getLibraries() {
        return this._libraries;
    }

    public ImportOrRemoveType[] defaultLibraries() {
        try {
            return new ImportOrRemoveType[0];
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addLibraries() throws ConfigurationException {
        if (this._libraries != null) {
            return;
        }
        ImportOrRemoveType[] libraries = new ImportOrRemoveType[]{new ImportOrRemoveType(this, null)};
        this.setLibraries(libraries);
    }

    public void removeLibraries() {
        if (this._libraries == null) {
            return;
        }
        this._libraries = null;
    }

    public void addLibrary(ImportOrRemoveType library) {
        library.setParent(this);
        int existingLibrariesCnt = 0;
        if (this._libraries != null) {
            existingLibrariesCnt = this._libraries.length;
        }
        ImportOrRemoveType[] newLibraries = new ImportOrRemoveType[existingLibrariesCnt + 1];
        for (int n = 0; n < existingLibrariesCnt; ++n) {
            newLibraries[n] = this._libraries[n];
        }
        newLibraries[existingLibrariesCnt] = library;
        ImportOrRemoveType[] oldValue = this._libraries;
        this._libraries = newLibraries;
        this.firePropertyChange("libraries", oldValue, this._libraries);
    }

    public void removeLibrary(ImportOrRemoveType library) {
        int existingLibrariesCnt = 0;
        if (this._libraries != null) {
            existingLibrariesCnt = this._libraries.length;
        }
        ImportOrRemoveType[] newLibraries = new ImportOrRemoveType[existingLibrariesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingLibrariesCnt; ++n) {
            if (library.equals(this._libraries[n])) continue;
            newLibraries[newIndex++] = this._libraries[n];
        }
        ImportOrRemoveType[] oldValue = this._libraries;
        this._libraries = newLibraries;
        this.firePropertyChange("libraries", oldValue, this._libraries);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "imported-shared-libraries");
        XMLUtils.writeTagAttributeEnd(out, indentation, "imported-shared-libraries");
        if (this._libraries != null) {
            ImportedLibrariesType.writeXML(out, indentation + "\t", this._libraries);
        }
        XMLUtils.writeTagEnd(out, indentation, "imported-shared-libraries");
    }

    private void init() throws ConfigurationException {
        this.setXpath("imported-shared-libraries");
        Vector<ImportOrRemoveType> libraries = new Vector<ImportOrRemoveType>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                ConfigBeanNode configBean;
                ImportOrRemoveType library;
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("import-shared-library")) {
                    library = new ImportOrRemoveType(this);
                    configBean = new ImportType(library, node);
                    library.setImport((ImportType)configBean);
                    libraries.add(library);
                    continue;
                }
                if (!name.equals("remove-inherited")) continue;
                library = new ImportOrRemoveType(this);
                configBean = new RemoveType(library, node);
                library.setRemove((RemoveType)configBean);
                libraries.add(library);
            }
        }
        if (libraries.size() > 0) {
            this._libraries = libraries.toArray(new ImportOrRemoveType[0]);
        }
    }
}

