/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.HostAccessTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.HostAccessType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class HostAccessesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_HOST_ACCESS_MENU_STRING = "Add Host Access";
    private JMenuItem _addHostAccessMenuItem;
    private HostAccessType[] hostAccessType = new HostAccessType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public HostAccessesTreeNode(ConfigTreeNode rootNode, MultipleType hostAccesses) {
        super(hostAccesses);
        this.setRootNode(rootNode);
        this._parentBean = hostAccesses.getConfigParent();
        this._addHostAccessMenuItem = new JMenuItem(ADD_HOST_ACCESS_MENU_STRING);
        this._addHostAccessMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addHostAccessMenuItem.setFont(HostAccessesTreeNode.getFont());
        this._addHostAccessMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addHostAccessMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getHostAccess", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addHostAccess", HostAccessType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeHostAccess", HostAccessType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Host Accesses";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            HostAccessType[] hostAccesses = (HostAccessType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (hostAccesses != null) {
                for (int i = 0; i < hostAccesses.length; ++i) {
                    HostAccessType hostAccess = hostAccesses[i];
                    if (hostAccess == null) continue;
                    HostAccessTreeNode hostAccessTreeNode = new HostAccessTreeNode(this.getRootNode(), hostAccess);
                    this.addChild(hostAccessTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            HostAccessType newHostAccess;
            if (event.getActionCommand().equals(ADD_HOST_ACCESS_MENU_STRING) && this.showAddDialog(newHostAccess = new HostAccessType(this._parentBean), ADD_HOST_ACCESS_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newHostAccess);
                HostAccessTreeNode newNode = new HostAccessTreeNode(this, newHostAccess);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof HostAccessTreeNode) {
            try {
                HostAccessType hostAccess = (HostAccessType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, hostAccess);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

