/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ErrorPageType
extends ConfigBeanNode {
    String errorCode;
    String exceptionType;
    String location;

    public ErrorPageType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("error-page");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (nodeName.equals("error-code")) {
                    this.errorCode = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("exception-type")) {
                    this.exceptionType = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!nodeName.equals("location")) continue;
                this.location = XMLUtils.getValue(childNodes.item(i));
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "error-page");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "error-code", this.errorCode);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "exception-type", this.exceptionType);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "location", this.location);
        XMLUtils.writeTagEnd(out, indentation, "error-page");
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public String getLocation() {
        return this.location;
    }
}

