/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.EncryptElementsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.EncryptionMethodConfigType;
import oracle.oc4j.admin.deploy.spi.xml.KeyConfigType;
import oracle.oc4j.admin.deploy.spi.xml.KeyTransportMethodConfigType;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptConfigType
extends ConfigBeanNode {
    KeyConfigType _recipientKey = null;
    BooleanType _useRequestCert = null;
    BooleanType _oldUseRequestCert = null;
    EncryptionMethodConfigType _encryptionMethod = null;
    KeyTransportMethodConfigType _keyTransportMethod = null;
    EncryptElementsConfigType _tbeElements = null;
    PropertyConfigBean[] _properties = null;

    public EncryptConfigType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public EncryptConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setRecipientKey(KeyConfigType recipientKey) throws ConfigurationException {
        KeyConfigType oldValue = this._recipientKey;
        this._recipientKey = recipientKey;
        this.firePropertyChange("recipientKey", oldValue, this._recipientKey);
    }

    public KeyConfigType getRecipientKey() {
        return this._recipientKey;
    }

    public KeyConfigType defaultRecipientKey() throws ConfigurationException {
        try {
            return new KeyConfigType(this, "recipient-key", null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addRecipientKey() throws ConfigurationException {
        if (this._recipientKey != null) {
            return;
        }
        KeyConfigType recipientKey = new KeyConfigType(this, "recipient-key", null);
        this.setRecipientKey(recipientKey);
    }

    public void removeRecipientKey() throws ConfigurationException {
        if (this._recipientKey == null) {
            return;
        }
        this.setRecipientKey(null);
    }

    public void setUseRequestCert(BooleanType useRequestCert) throws ConfigurationException {
        this._useRequestCert = useRequestCert;
        this.firePropertyChange("useRequestCert", this._oldUseRequestCert, this._useRequestCert);
        if (this._useRequestCert != null) {
            if (this._oldUseRequestCert == null) {
                this._oldUseRequestCert = this.defaultUseRequestCert();
            }
            this._oldUseRequestCert.setValue(this._useRequestCert.getValue());
        } else {
            this._oldUseRequestCert = null;
        }
    }

    public BooleanType getUseRequestCert() {
        return this._useRequestCert;
    }

    public BooleanType defaultUseRequestCert() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setEncryptionMethod(EncryptionMethodConfigType encryptionMethod) throws ConfigurationException {
        EncryptionMethodConfigType oldValue = this._encryptionMethod;
        this._encryptionMethod = encryptionMethod;
        this.firePropertyChange("encryptionMethod", oldValue, this._encryptionMethod);
    }

    public EncryptionMethodConfigType getEncryptionMethod() {
        return this._encryptionMethod;
    }

    public EncryptionMethodConfigType defaultEncryptionMethod() {
        try {
            return new EncryptionMethodConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addEncryptionMethod() throws ConfigurationException {
        if (this._encryptionMethod != null) {
            return;
        }
        EncryptionMethodConfigType encryptionMethod = new EncryptionMethodConfigType(this, null);
        this.setEncryptionMethod(encryptionMethod);
    }

    public void removeEncryptionMethod() throws ConfigurationException {
        if (this._encryptionMethod == null) {
            return;
        }
        this.setEncryptionMethod(null);
    }

    public void setKeyTransportMethod(KeyTransportMethodConfigType keyTransportMethod) throws ConfigurationException {
        KeyTransportMethodConfigType oldValue = this._keyTransportMethod;
        this._keyTransportMethod = keyTransportMethod;
        this.firePropertyChange("keyTransportMethod", oldValue, this._keyTransportMethod);
    }

    public KeyTransportMethodConfigType getKeyTransportMethod() {
        return this._keyTransportMethod;
    }

    public KeyTransportMethodConfigType defaultKeyTransportMethod() {
        try {
            return new KeyTransportMethodConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addKeyTransportMethod() throws ConfigurationException {
        if (this._keyTransportMethod != null) {
            return;
        }
        KeyTransportMethodConfigType keyTransportMethod = new KeyTransportMethodConfigType(this, null);
        this.setKeyTransportMethod(keyTransportMethod);
    }

    public void removeKeyTransportMethod() throws ConfigurationException {
        if (this._keyTransportMethod == null) {
            return;
        }
        this.setKeyTransportMethod(null);
    }

    public void setTbeElements(EncryptElementsConfigType tbeElements) throws ConfigurationException {
        EncryptElementsConfigType oldValue = this._tbeElements;
        this._tbeElements = tbeElements;
        this.firePropertyChange("tbeElements", oldValue, this._tbeElements);
    }

    public EncryptElementsConfigType getTbeElements() {
        return this._tbeElements;
    }

    public EncryptElementsConfigType defaultTbeElements() {
        try {
            return new EncryptElementsConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addTbeElements() throws ConfigurationException {
        if (this._tbeElements != null) {
            return;
        }
        EncryptElementsConfigType tbeElements = new EncryptElementsConfigType(this, null);
        this.setTbeElements(tbeElements);
    }

    public void removeTbeElements() throws ConfigurationException {
        if (this._tbeElements == null) {
            return;
        }
        this.setTbeElements(null);
    }

    public void setProperties(PropertyConfigBean[] properties) throws ConfigurationException {
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        return new PropertyConfigBean[0];
    }

    public void addProperties() throws ConfigurationException {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() throws ConfigurationException {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) throws ConfigurationException {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) throws ConfigurationException {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "encrypt");
        XMLUtils.writeTagAttributeEnd(out, indentation, "encrypt");
        if (this._recipientKey != null) {
            this._recipientKey.writeXML(out, indentation + "\t");
        }
        if (this._useRequestCert != null) {
            XMLUtils.writeTag(out, indentation + "\t", "use-request-cert", this._useRequestCert);
        }
        if (this._encryptionMethod != null) {
            this._encryptionMethod.writeXML(out, indentation + "\t");
        }
        if (this._keyTransportMethod != null) {
            this._keyTransportMethod.writeXML(out, indentation + "\t");
        }
        if (this._tbeElements != null) {
            this._tbeElements.writeXML(out, indentation + "\t");
        }
        EncryptConfigType.writeXML(out, indentation + "\t", this._properties);
        XMLUtils.writeTagEnd(out, indentation, "encrypt");
    }

    private void init() throws ConfigurationException {
        this.setXpath("encrypt");
        Vector<PropertyConfigBean> properties = new Vector<PropertyConfigBean>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("recipient-key")) {
                    KeyConfigType recipientKey = new KeyConfigType(this, "recipient-key", node);
                    this.setRecipientKey(recipientKey);
                    continue;
                }
                if (name.equals("use-request-cert")) {
                    BooleanType useRequestCert = this.defaultUseRequestCert();
                    useRequestCert.setValue(XMLUtils.getValue(node));
                    this.setUseRequestCert(useRequestCert);
                    continue;
                }
                if (name.equals("encryption-method")) {
                    this.setEncryptionMethod(new EncryptionMethodConfigType(this, node));
                    continue;
                }
                if (name.equals("keytransport-method")) {
                    this.setKeyTransportMethod(new KeyTransportMethodConfigType(this, node));
                    continue;
                }
                if (name.equals("tbe-elements")) {
                    this.setTbeElements(new EncryptElementsConfigType(this, node));
                    continue;
                }
                if (!name.equals("property")) continue;
                PropertyConfigBean configBean = new PropertyConfigBean(this, node);
                properties.add(configBean);
            }
        }
        if (properties.size() > 0) {
            this.setProperties(properties.toArray(new PropertyConfigBean[0]));
        }
    }
}

