/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ConnectionPoolTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ConnectionPoolType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class ConnectionPoolsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_CONNECTION_POOL_MENU_STRING = "Add Connection Pool";
    private JMenuItem _addConnectionPoolMenuItem;
    private ConnectionPoolType[] connectionPoolsType = new ConnectionPoolType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public ConnectionPoolsTreeNode(ConfigTreeNode rootNode, MultipleType connectionPools) {
        super(connectionPools);
        this.setRootNode(rootNode);
        this._parentBean = connectionPools.getConfigParent();
        this._addConnectionPoolMenuItem = new JMenuItem(ADD_CONNECTION_POOL_MENU_STRING);
        this._addConnectionPoolMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addConnectionPoolMenuItem.setFont(ConnectionPoolsTreeNode.getFont());
        this._addConnectionPoolMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addConnectionPoolMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getConnectionPools", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addConnectionPool", ConnectionPoolType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeConnectionPool", ConnectionPoolType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Connection Pools";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            ConnectionPoolType[] connectionPools = (ConnectionPoolType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (connectionPools != null) {
                for (int i = 0; i < connectionPools.length; ++i) {
                    ConnectionPoolType connectionPool = connectionPools[i];
                    if (connectionPool == null) continue;
                    ConnectionPoolTreeNode connectionPoolTreeNode = new ConnectionPoolTreeNode(this.getRootNode(), connectionPool);
                    this.addChild(connectionPoolTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            ConnectionPoolType newConnectionPool;
            if (event.getActionCommand().equals(ADD_CONNECTION_POOL_MENU_STRING) && this.showAddDialog(newConnectionPool = new ConnectionPoolType(this._parentBean), ADD_CONNECTION_POOL_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newConnectionPool);
                ConnectionPoolTreeNode newNode = new ConnectionPoolTreeNode(this, newConnectionPool);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ConnectionPoolTreeNode) {
            try {
                ConnectionPoolType connectionPool = (ConnectionPoolType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, connectionPool);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

