/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigPropertyType
extends ConfigBeanNode {
    String _name = null;
    String _value = null;

    public ConfigPropertyType(ConfigBeanNode parent) {
        this(parent, null);
    }

    public ConfigPropertyType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void setName(String name) {
        String oldValue = this._name;
        this._name = name;
        this.firePropertyChange("name", oldValue, this._name);
    }

    public String getName() {
        return this._name;
    }

    public String defaultName() {
        return "";
    }

    public void setValue(String value) {
        String oldValue = this._value;
        this._value = value;
        this.firePropertyChange("value", oldValue, this._value);
    }

    public String defaultValue() {
        return "";
    }

    public String getValue() {
        return this._value;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._name != null && this._name.length() > 0) {
            XMLUtils.writeTagAttributeStart(out, indentation, "config-property");
            XMLUtils.writeAttribute(out, indentation, "name", this._name);
            XMLUtils.writeAttributeForce(out, indentation, "value", this._value);
            XMLUtils.writeTagAttributeEnd(out, indentation, "config-property");
            XMLUtils.writeTagEnd(out, indentation, "config-property");
        }
    }

    public void putXpath() {
        if (this.getConfigParent() != null) {
            this.setXpath("config-property");
        }
    }

    private void init() {
        this.putXpath();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "name");
            if (val != null && !val.trim().equals("")) {
                this._name = val;
            }
            if ((val = XMLUtils.getAttribute(node, "value")) != null && !val.trim().equals("")) {
                this._value = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
            }
        }
    }
}

