/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.status;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;

public class ExtendedProgressEvent
extends ProgressEvent {
    private long eventTimeStamp_ = -1L;
    private long sequenceNumber_ = -1L;

    public ExtendedProgressEvent(Object source, TargetModuleID tid, DeploymentStatus status, long timeStamp, long sequenceNumber) {
        super(source, tid, status);
        this.eventTimeStamp_ = timeStamp;
        this.sequenceNumber_ = sequenceNumber;
    }

    public final long getTimeStamp() {
        return this.eventTimeStamp_;
    }

    public final long getSequenceNumber() {
        return this.sequenceNumber_;
    }

    public final String getFormatedTimeStamp() {
        SimpleDateFormat df = new SimpleDateFormat("yy/MM/dd HH:mm:ss", Locale.getDefault());
        return df.format(new Date(this.getTimeStamp()));
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getDeploymentStatus().toString());
        buff.append("Time: ");
        buff.append(this.getFormatedTimeStamp());
        buff.append("\n");
        buff.append("Sequence number: " + this.getSequenceNumber());
        buff.append("\n");
        buff.append("TargetModuleID: " + this.getTargetModuleID());
        buff.append("\n");
        return buff.toString();
    }

    public String toCmdlineString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getFormatedTimeStamp());
        buff.append(" Notification ==>");
        buff.append(this.getDeploymentStatus().getMessage());
        buff.append("\n");
        return buff.toString();
    }
}

