/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.shell;

import java.io.OutputStream;
import java.util.List;
import javax.enterprise.deploy.spi.TargetModuleID;
import oracle.oc4j.admin.deploy.shell.AdminShell;
import oracle.oc4j.admin.deploy.shell.DeployerBase;
import oracle.oc4j.admin.deploy.shell.DeployerUtils;
import oracle.oc4j.admin.deploy.spi.ConnectedDeploymentManagerBase;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.deploy.spi.TargetModuleIDImpl;
import oracle.oc4j.admin.deploy.spi.exceptions.DeploymentRuntimeException;
import oracle.oc4j.admin.deploy.spi.status.DeployProgressListenerWriter;

class DeployerImpl
implements DeployerBase {
    DeployerImpl() {
    }

    public void handleDeployment(List arguments) throws DeploymentRuntimeException, IllegalArgumentException {
        throw new DeploymentRuntimeException("This operation is not supported in this class. Please use its extended subclass.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUnDeployment(List arguments) throws DeploymentRuntimeException, IllegalArgumentException {
        DeployerUtils deployerUtils = new DeployerUtils();
        deployerUtils.processUndeployParameters(arguments);
        if (!deployerUtils.isUndeployParamSuccess()) {
            throw new IllegalArgumentException("Can not get undeployment parameters correctly");
        }
        String appName = deployerUtils.getAppNameForUndeploy();
        boolean isConnector = deployerUtils.isConnector();
        boolean keepFiles = deployerUtils.isKeepFiles();
        ProprietaryConnectedDeploymentManager pcDeplMgr = AdminShell.getProprietaryConnectedDeplManag();
        try {
            String undeploymentMonitor;
            String string = undeploymentMonitor = "undeploymentMonitor";
            synchronized (string) {
                DeployProgressListenerWriter listener = new DeployProgressListenerWriter((OutputStream)System.out, (Object)undeploymentMonitor);
                TargetModuleID[] tids = deployerUtils.getTargetModuleID(appName, isConnector);
                pcDeplMgr.undeploy(tids, listener);
                undeploymentMonitor.wait();
            }
        }
        catch (Exception e) {
            throw new DeploymentRuntimeException("Error undeploying application " + appName + ": " + e.getMessage());
        }
    }

    public void handleBindWebModule(List arguments) throws DeploymentRuntimeException, IllegalArgumentException {
        String applicationName = null;
        String webModuleName = null;
        String webSiteName = null;
        String contextRoot = null;
        while (!arguments.isEmpty()) {
            String command = AdminShell.getNextArgumentFromShell(arguments, "bind subcommand");
            if (command.equalsIgnoreCase("-app")) {
                applicationName = AdminShell.getNextArgumentFromShell(arguments, "app filename");
                continue;
            }
            if (command.equalsIgnoreCase("-module")) {
                webModuleName = AdminShell.getNextArgumentFromShell(arguments, "web module name");
                continue;
            }
            if (command.equalsIgnoreCase("-site")) {
                webSiteName = AdminShell.getNextArgumentFromShell(arguments, "web site name");
                continue;
            }
            if (command.equalsIgnoreCase("-root")) {
                contextRoot = AdminShell.getNextArgumentFromShell(arguments, "context root");
                continue;
            }
            throw new IllegalArgumentException("Unknown bind switch: " + command);
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Error: no application name specified.");
        }
        if (webModuleName == null) {
            throw new IllegalArgumentException("Error: no web module specified.");
        }
        if (webSiteName == null) {
            throw new IllegalArgumentException("Error: no web site specified.");
        }
        if (contextRoot == null) {
            throw new IllegalArgumentException("Error: no context root specified.");
        }
        try {
            DeployerUtils deployerUtils = new DeployerUtils();
            TargetModuleIDImpl moduleID = deployerUtils.getTargetModuleID(applicationName, webModuleName);
            ConnectedDeploymentManagerBase cDeplMgrBase = AdminShell.getConnectedDeplMgrBase();
            cDeplMgrBase.bindWebApp((TargetModuleID)moduleID, webSiteName, contextRoot);
        }
        catch (Exception e) {
            throw new DeploymentRuntimeException("Error binding: " + e.getMessage());
        }
    }

    public void handleBindApp(List arguments) throws DeploymentRuntimeException, IllegalArgumentException {
        String applicationName = null;
        String webSiteName = null;
        while (!arguments.isEmpty()) {
            String command = AdminShell.getNextArgumentFromShell(arguments, "bind subcommand");
            if (command.equalsIgnoreCase("-app")) {
                applicationName = AdminShell.getNextArgumentFromShell(arguments, "application name");
                continue;
            }
            if (command.equalsIgnoreCase("-site")) {
                webSiteName = AdminShell.getNextArgumentFromShell(arguments, "web site name");
                continue;
            }
            throw new IllegalArgumentException("Error: Unknown bind switch: " + command);
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Error: no application name specified.");
        }
        if (webSiteName == null) {
            throw new IllegalArgumentException("Error: no web site specified.");
        }
        try {
            DeployerUtils deployerUtils = new DeployerUtils();
            TargetModuleIDImpl moduleID = deployerUtils.getTargetModuleID(applicationName);
            ConnectedDeploymentManagerBase cDeplMgrBase = AdminShell.getConnectedDeplMgrBase();
            cDeplMgrBase.bindWebApp(moduleID, webSiteName);
        }
        catch (Exception e) {
            throw new DeploymentRuntimeException("Error binding: " + e.getMessage());
        }
    }
}

