/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.EjbRelationshipRoleBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EjbRelationBean
extends BeanNode {
    public EjbRelationBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getEjbRelationName() {
        return this.nodeValue("ejb-relation-name");
    }

    protected Collection createSpecialJTreeChildren() {
        Vector<CollectionJTreeNode> vec = new Vector<CollectionJTreeNode>();
        String childPath = "ejb-relationship-role";
        CollectionJTreeNode node = new CollectionJTreeNode(this, childPath, "Ejb Relationship Roles", true);
        vec.add(node);
        return vec;
    }

    public String toString() {
        return "Ejb Relation";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "ejb-relation" + ">");
        EjbRelationBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        EjbRelationBean.writeAll(this.getChildBean("ejb-relation-name"), out, indentation + "\t");
        EjbRelationBean.writeAll(this.getChildBean("ejb-relationship-role"), out, indentation + "\t");
        out.println(indentation + "</" + "ejb-relation" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("ejb-relation");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> ejbRelationName = new Vector<StringBean>(1);
        Vector<StringBean> ejbRelationshipRoles = new Vector<StringBean>(2);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((StringBean)bean);
            }
            if (name.equals("ejb-relation-name")) {
                bean = new StringBean(node, this, "ejb-relation-name");
                ejbRelationName.add((StringBean)bean);
            }
            if (!name.equals("ejb-relationship-role")) continue;
            bean = new EjbRelationshipRoleBean(node, this);
            ejbRelationshipRoles.add((StringBean)bean);
        }
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("ejb-relation-name", ejbRelationName);
        this.recordXpathForBeans("ejb-relationship-role", ejbRelationshipRoles);
    }
}

