/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.MethodBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContainerTransactionBean
extends BeanNode {
    public ContainerTransactionBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getTransAttribute() {
        return this.nodeValue("trans-attribute");
    }

    protected Collection createSpecialJTreeChildren() {
        Vector<CollectionJTreeNode> vec = new Vector<CollectionJTreeNode>();
        String childPath = "method";
        CollectionJTreeNode node = new CollectionJTreeNode(this, childPath, "Methods", true);
        vec.add(node);
        return vec;
    }

    public String toString() {
        return "Container Transaction";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "container-transaction" + ">");
        ContainerTransactionBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        ContainerTransactionBean.writeAll(this.getChildBean("method"), out, indentation + "\t");
        ContainerTransactionBean.writeAll(this.getChildBean("trans-attribute"), out, indentation + "\t");
        out.println(indentation + "</" + "container-transaction" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("container-transaction");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> methods = new Vector<StringBean>();
        Vector<StringBean> transAttribute = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((StringBean)bean);
            }
            if (name.equals("method")) {
                bean = new MethodBean(node, this);
                methods.add((StringBean)bean);
            }
            if (!name.equals("trans-attribute")) continue;
            bean = new StringBean(node, this, "trans-attribute");
            transAttribute.add((StringBean)bean);
        }
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("method", methods);
        this.recordXpathForBeans("trans-attribute", transAttribute);
    }
}

