/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import oracle.oc4j.admin.deploy.gui.BeanPane;
import oracle.oc4j.admin.deploy.gui.CreationException;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.shared.xml.J2eeXmlNode;
import oracle.oc4j.admin.deploy.shared.xml.XMLizable;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;

public abstract class BeanNode
extends J2eeXmlNode
implements XMLizable,
DDBean,
ViewableJTreeNode {
    protected DDBean[] _thisBean = null;
    protected DConfigBean _configBeanLink = null;
    protected Vector _jtreeChildren = new Vector();
    protected ViewableJTreeNode _jtreeParent;
    protected boolean _jtreeChanged = true;
    protected JComponent _viewPane;
    private boolean _semiSelected;

    public BeanNode(Node node, DDBean parent) {
        this(node);
        if (parent instanceof BeanNode) {
            this._parent = (J2eeXmlNode)parent;
        }
    }

    public BeanNode(Node node) {
        super(node);
        this._thisBean = new DDBean[1];
        this._thisBean[0] = this;
    }

    public void setJTreeParent(ViewableJTreeNode parent) {
        this._jtreeParent = parent;
    }

    public String jtreeIconName() {
        String xpath = this.getXpath();
        if (xpath.indexOf(47) >= 0) {
            xpath = xpath.substring(xpath.lastIndexOf(47) + 1);
        }
        if (xpath.length() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(xpath);
        buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
        int index = xpath.length();
        while ((index = xpath.lastIndexOf(45, index - 1)) >= 0) {
            buf.deleteCharAt(index);
            buf.setCharAt(index, Character.toUpperCase(buf.charAt(index)));
        }
        return new String(buf);
    }

    public String jtreeToolTip() {
        return null;
    }

    public DDBeanRoot getRoot() {
        return (DDBeanRoot)this.getFirstParent();
    }

    public DDBean[] getChildBean(String xpath) {
        Vector v;
        if (xpath.equals(".")) {
            return this._thisBean;
        }
        if (xpath.equals("..")) {
            return ((BeanNode)this._parent)._thisBean;
        }
        if (xpath.startsWith("./")) {
            String remainingXpath = xpath.substring(2);
            return this.getChildBean(remainingXpath);
        }
        if (xpath.startsWith("../")) {
            String remainingXpath = xpath.substring(2);
            return this.getChildBean(remainingXpath);
        }
        if (xpath.startsWith("../")) {
            String remainingXpath = xpath.substring(3);
            return ((BeanNode)this._parent).getChildBean(remainingXpath);
        }
        if (xpath.equals(this.getXpath())) {
            return this._thisBean;
        }
        if (xpath.startsWith(this.getXpath())) {
            Vector v2;
            String remainingXpath = xpath.substring(this.getXpath().length());
            if (remainingXpath.startsWith("/")) {
                remainingXpath = remainingXpath.substring(1);
            }
            if ((v2 = this.resolveXpath(remainingXpath)) != null) {
                DDBean[] beans = new DDBean[v2.size()];
                return v2.toArray(beans);
            }
            return null;
        }
        if (!xpath.startsWith("/") && (v = this.resolveXpath(xpath)) != null) {
            DDBean[] beans = new DDBean[v.size()];
            return v.toArray(beans);
        }
        return null;
    }

    public String nodeValue(String name) {
        Node node;
        Vector v = this.resolveXpath(name);
        if (v != null && v.size() == 1 && (node = ((BeanNode)v.elementAt(0)).getNode()) != null) {
            return XMLUtils.getValue(node);
        }
        return "";
    }

    public String allNodesValue(String name) {
        String val = "";
        Vector v = this.resolveXpath(name);
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                Node node = ((BeanNode)v.elementAt(i)).getNode();
                if (node == null) continue;
                val = val + XMLUtils.getValue(node);
                if (i + 1 >= v.size()) continue;
                val = val + ", ";
            }
        }
        return val;
    }

    public String[] getText(String xpath) {
        DDBean[] children = this.getChildBean(xpath);
        if (children != null) {
            String[] ret = new String[children.length];
            for (int n = 0; n < children.length; ++n) {
                BeanNode child = (BeanNode)children[n];
                ret[n] = new String(XMLUtils.getValue(child.getNode()));
            }
            return ret;
        }
        return null;
    }

    public String[] getAttributeNames() {
        return XMLUtils.getAttributeNames(this.getNode());
    }

    public String getAttribute(String attr) {
        return this.getAttributeValue(attr);
    }

    public String getAttributeValue(String attrName) {
        if (this.getNode() == null) {
            return "";
        }
        return XMLUtils.getAttribute(this.getNode(), attrName);
    }

    public String getId() {
        if (this.getNode() == null) {
            return null;
        }
        return this.getAttribute("id");
    }

    public void addXpathListener(String xpath, XpathListener xpl) {
    }

    public void removeXpathListener(String xpath, XpathListener xpl) {
    }

    public static void writeAll(DDBean[] col, PrintWriter out, String indention) throws ExtendedRuntimeException {
        if (col == null) {
            return;
        }
        for (int n = 0; n < col.length; ++n) {
            XMLizable elem = (XMLizable)col[n];
            elem.writeXML(out, indention);
        }
    }

    protected String[] listJTreeChildPaths() {
        return new String[0];
    }

    protected void buildChildJTree() {
        if (this._jtreeChanged) {
            String[] children = this.listJTreeChildPaths();
            for (int i = 0; i < children.length; ++i) {
                DDBean[] beans = this.getChildBean(children[i]);
                for (int j = 0; j < beans.length; ++j) {
                    this.addJTreeChild((ViewableJTreeNode)beans[j]);
                }
            }
            Collection col = this.createSpecialJTreeChildren();
            if (col != null) {
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    this.addJTreeChild((ViewableJTreeNode)it.next());
                }
            }
            this._jtreeChanged = false;
        }
    }

    public void setLinkedConfigBean(DConfigBean configBean) {
        this._configBeanLink = configBean;
    }

    public DConfigBean getLinkedConfigBean() {
        return this._configBeanLink;
    }

    public BeanNode[] childBeansToDisplay() {
        return null;
    }

    protected Collection createSpecialJTreeChildren() {
        return null;
    }

    protected int getNumJTreeChildren() {
        return this._jtreeChildren.size();
    }

    public void addJTreeChild(ViewableJTreeNode child) {
        this._jtreeChildren.add(child);
        child.setJTreeParent(this);
    }

    public String viewHeaderString() {
        return this.getXpath();
    }

    protected void recordXpathForBeans(String xpath, Vector objs) {
        super.recordXpathForBeans(xpath, objs);
        this._jtreeChanged = true;
    }

    protected void removeXpathForBeans(String xpath) {
        super.removeXpathForBeans(xpath);
        this._jtreeChanged = true;
    }

    protected boolean leaf() {
        return false;
    }

    public JComponent viewComponent() throws CreationException {
        this._viewPane = new BeanPane(this);
        return this._viewPane;
    }

    public TreeNode getChildAt(int childIndex) {
        this.buildChildJTree();
        return (TreeNode)this._jtreeChildren.elementAt(childIndex);
    }

    public int getChildCount() {
        this.buildChildJTree();
        return this._jtreeChildren.size();
    }

    public TreeNode getParent() {
        if (this._jtreeParent != null) {
            return this._jtreeParent;
        }
        return (TreeNode)((Object)this.getXmlParent());
    }

    public int getIndex(TreeNode node) {
        this.buildChildJTree();
        return this._jtreeChildren.indexOf(node);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this.leaf();
    }

    public Enumeration children() {
        this.buildChildJTree();
        return this._jtreeChildren.elements();
    }

    public ViewableJTree[] subTrees() {
        if (this._configBeanLink != null && this._configBeanLink instanceof ConfigBeanNode) {
            return ((ConfigBeanNode)this._configBeanLink).subTrees();
        }
        return null;
    }

    public void setSemiSelected(boolean sel) {
        this._semiSelected = sel;
    }

    public boolean isSemiSelected() {
        return this._semiSelected;
    }

    public Collection getPopupMenuItems(ViewableJTree jtree) {
        return null;
    }

    public String toString() {
        String val = this.getText(".")[0];
        if (val == null || val.equals("")) {
            // empty if block
        }
        val = this.getXpath();
        return val;
    }
}

