/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.file;

import java.io.File;
import java.io.InputStream;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.shared.ModuleType;
import oracle.oc4j.admin.deploy.model.file.EarFile;
import oracle.oc4j.admin.deploy.model.file.J2eeFile;
import oracle.oc4j.admin.deploy.model.xml.BeanRootNode;
import oracle.oc4j.admin.deploy.model.xml.RarStdXml;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.xml.parser.v2.XMLDocument;

public class RarFile
extends J2eeFile
implements DeployableObject {
    public RarFile(File rarfile) throws ExtendedRuntimeException {
        this(rarfile, null, null, false);
    }

    public RarFile(File rarfile, boolean dtdValidation) throws ExtendedRuntimeException {
        this(rarfile, null, null, dtdValidation);
    }

    public RarFile(File rarfile, String jarEntry, EarFile parent, boolean dtdValidation) throws ExtendedRuntimeException {
        this(rarfile, null, jarEntry, parent, dtdValidation);
    }

    public RarFile(String altDD, String jarEntry, EarFile parent, boolean dtdValidation) throws ExtendedRuntimeException {
        this(null, altDD, jarEntry, parent, dtdValidation);
    }

    public RarFile(File rarfile, String altDD, String jarEntry, EarFile parent, boolean dtdValidation) throws ExtendedRuntimeException {
        super(rarfile, jarEntry, parent, dtdValidation);
        this.init(altDD);
    }

    public ModuleType getType() {
        return ModuleType.RAR;
    }

    public void addXpathListener(ModuleType type, String xpath, XpathListener xpl) {
    }

    public void removeXpathListener(ModuleType type, String xpath, XpathListener xpl) {
    }

    public boolean checkStdXml(BeanRootNode stdXml) {
        return this.checkParam(stdXml, "oracle.oc4j.admin.deploy.model.xml.RarStdXml");
    }

    public String getStdXmlEntry() {
        return "META-INF/ra.xml";
    }

    public static RarFile copy(InputStream inStrm) throws ExtendedRuntimeException {
        try {
            File tmpRar = File.createTempFile("dep", ".rar");
            RarFile.copyStreamToFile(inStrm, tmpRar);
            RarFile ret = new RarFile(tmpRar);
            ret._tmpFile = true;
            return ret;
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    private void init(String altDD) throws ExtendedRuntimeException {
        try {
            File rarFile = this.getFile();
            XMLDocument doc = null;
            doc = altDD == null ? (rarFile != null ? this.getXmlDocument(this.getStdXmlEntry()) : this.getXmlDocument(this.getURI(), this.getStdXmlEntry())) : this.getParent().getXmlDocument(altDD);
            if (doc == null) {
                if (altDD == null) {
                    if (rarFile == null) {
                        throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("missingStdDesc", new String[]{this._entryName, this.getStdXmlEntry()}));
                    }
                    throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("missingStdDesc", new String[]{rarFile.getAbsolutePath(), this.getStdXmlEntry()}));
                }
                throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("missingStdDesc", new String[]{this.getParent().getFile().getAbsolutePath(), altDD}));
            }
            this.setStdXml(new RarStdXml(doc, this));
        }
        catch (ExtendedRuntimeException ExT) {
            this.close();
            throw ExT;
        }
        catch (Throwable t) {
            this.close();
            throw new ExtendedRuntimeException(t);
        }
    }
}

