/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.Insets;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.oc4j.admin.deploy.gui.DataElement;
import oracle.oc4j.admin.deploy.gui.DataEntryElementBase;

public class StringDataEntryElement
extends DataEntryElementBase {
    protected boolean _pwd;

    public StringDataEntryElement(String name) {
        this(name, null, false, false);
    }

    public StringDataEntryElement(String name, String value) {
        this(name, value, false, false);
    }

    public StringDataEntryElement(String name, boolean optional) {
        this(name, null, optional, false);
    }

    public StringDataEntryElement(DataElement elem) {
        super(elem);
        this.initComponent(elem.getValueAsString());
    }

    protected StringDataEntryElement(String name, String value, boolean optional, boolean pwd) {
        super(name, value, optional);
        this._pwd = pwd;
        this.initComponent(value);
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.getTextField().setEditable(!readOnly);
    }

    protected boolean isPassword() {
        return this._pwd;
    }

    protected void initComponent(String value) {
        JTextField textField = null;
        textField = this.isPassword() ? new JPasswordField(value) : new JTextField(value);
        Insets margin = textField.getMargin();
        margin.left = 3;
        margin.right = 3;
        textField.setMargin(margin);
        this.setSwingComponent(textField);
    }

    private JTextField getTextField() {
        return (JTextField)this.getSwingComponent();
    }

    public Object getValueFromComponent() {
        String value = null;
        value = this.isPassword() ? new String(((JPasswordField)this.getSwingComponent()).getPassword()) : this.getTextField().getText();
        if (value.trim().length() == 0) {
            value = null;
        }
        return value;
    }

    protected void setValueInComponent(Object value) {
        String val = value == null ? "" : value.toString();
        this.getTextField().setText(val);
    }
}

