/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import oracle.oc4j.admin.deploy.gui.ComboDataEntryElement;
import oracle.oc4j.admin.deploy.gui.DataEntryDialog;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.ListDataEntryElement;
import oracle.oc4j.admin.deploy.gui.StringDataEntryElement;
import oracle.oc4j.admin.management.shared.ImportSharedLibrary;
import oracle.oc4j.admin.management.shared.SharedLibrary;

public class ImportLibDataEntryElement
extends ListDataEntryElement {
    private Vector _imports = new Vector();

    public ImportLibDataEntryElement(String name, SharedLibrary[] libs) {
        super(name, null, libs);
    }

    public void promptForNewElement() {
        ComboDataEntryElement libsElem = new ComboDataEntryElement("Shared Library", this.getChoices());
        StringDataEntryElement minVer = new StringDataEntryElement("Min Version", true);
        StringDataEntryElement maxVer = new StringDataEntryElement("Max Version", true);
        DataEntryElement[] elems = new DataEntryElement[]{libsElem, minVer, maxVer};
        DataEntryDialog dlg = DataEntryDialog.createSimpleDataEntryDialog(elems, "Import Library", "Specify Import Library");
        if (dlg.showDialog()) {
            SharedLibrary lib = (SharedLibrary)libsElem.getValue();
            this.getChoices().remove(lib);
            this._imports.add(lib);
            this.addItem(new ImportSharedLibrary(lib.getName(), minVer.getValueAsString(), maxVer.getValueAsString()));
        }
    }

    public Object getValueFromComponent() {
        int size = this.getTheModel().getSize();
        ImportSharedLibrary[] elems = new ImportSharedLibrary[size];
        for (int i = 0; i < size; ++i) {
            elems[i] = (ImportSharedLibrary)this.getTheModel().getElementAt(i);
        }
        return elems;
    }

    public void removeSelectedElement() {
        JList theList = this.getTheList();
        DefaultListModel theModel = this.getTheModel();
        Vector choices = this.getChoices();
        int index = theList.getSelectedIndex();
        ImportSharedLibrary lib = (ImportSharedLibrary)theModel.remove(index);
        for (int i = 0; i < this._imports.size(); ++i) {
            SharedLibrary shLib = (SharedLibrary)this._imports.get(i);
            if (!shLib.getName().equals(lib.getName())) continue;
            this._imports.removeElementAt(i);
            choices.add(shLib);
        }
        int size = theModel.getSize();
        if (size > 0) {
            if (index == size) {
                --index;
            }
            theList.setSelectedIndex(index);
            theList.ensureIndexIsVisible(index);
        }
    }
}

