/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import oracle.oc4j.admin.deploy.gui.CreationException;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;

public class DualTreeViewPane
extends JPanel
implements TreeSelectionListener {
    protected ViewableJTree _upperTree = null;
    protected ViewableJTree _lastSelectedTree = null;
    protected JScrollPane _upperTreePanel;
    protected JPanel _lowerTreePanel;
    protected JComponent _currentTreeComponent;
    protected JScrollPane _viewPanel;
    protected JSplitPane _treePanel;
    protected JPanel _emptyPanel;
    protected static final String EMPTY_PANEL = "EMPTY PANEL";
    protected JScrollPane _lowerScrollPane;
    protected JTabbedPane _lowerTabbedPane;
    protected Hashtable _nodeViews = new Hashtable();
    protected Hashtable _nodeSubTrees = new Hashtable();
    private int _treeWidth;
    private int _treeHeight;

    public DualTreeViewPane(int treeWidth, int viewWidth, int height) {
        this.setLayout(new BorderLayout());
        this._treeWidth = treeWidth;
        this._treeHeight = height;
        this._emptyPanel = new JPanel();
        this._emptyPanel.setOpaque(false);
        this._upperTreePanel = new JScrollPane();
        this._upperTreePanel.setMinimumSize(new Dimension(treeWidth / 2, height / 4));
        this._upperTreePanel.setPreferredSize(new Dimension(treeWidth, (int)((double)height * 0.33)));
        this._upperTreePanel.getViewport().setBackground(Deployer.TreeBackgroundColor);
        this._lowerTreePanel = new JPanel();
        this._lowerTreePanel.setBackground(Deployer.TreeBackgroundColor);
        this._lowerTreePanel.setPreferredSize(new Dimension(treeWidth, (int)((double)height * 0.67)));
        this._lowerTreePanel.setLayout(new CardLayout());
        this._lowerTreePanel.setBorder(null);
        this._lowerTreePanel.add((Component)this._emptyPanel, EMPTY_PANEL);
        this._treePanel = new JSplitPane(0, this._upperTreePanel, this._lowerTreePanel);
        this._treePanel.setContinuousLayout(true);
        this._treePanel.setResizeWeight(0.33);
        this._treePanel.setDividerSize(5);
        this._treePanel.setMinimumSize(new Dimension(treeWidth / 2, height / 4));
        this._viewPanel = new JScrollPane();
        this._viewPanel.setPreferredSize(new Dimension(viewWidth, height));
        this._viewPanel.getViewport().setBackground(Deployer.ViewBackgroundColor);
        JSplitPane splitPane = new JSplitPane(1, this._treePanel, this._viewPanel);
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight((float)treeWidth / (float)(treeWidth + viewWidth));
        splitPane.setDividerSize(5);
        this.add((Component)splitPane, "Center");
    }

    public void setUpperTree(ViewableJTree tree) {
        if (tree == null) {
            this.clear();
        } else {
            this._lastSelectedTree = this._upperTree = tree;
            this._upperTree.setBackground(Deployer.TreeBackgroundColor);
            this._upperTree.addTreeSelectionListener(this);
            this._upperTreePanel.setViewportView(this._upperTree);
            ViewableJTreeNode node = this._upperTree.getRootNode();
            if (!this._upperTree.isRootVisible() && node.getChildCount() > 0) {
                node = (ViewableJTreeNode)node.getChildAt(0);
            }
            try {
                this._viewPanel.setViewportView(node.viewComponent());
            }
            catch (CreationException ce) {
                GuiUtil.errDialog("Error creating view for node " + node);
                ce.printStackTrace();
                this._viewPanel.setViewportView(new JPanel());
            }
        }
    }

    protected void clear() {
        if (this._upperTree == null) {
            return;
        }
        this._upperTree = null;
        this._lastSelectedTree = null;
        this._currentTreeComponent = null;
        this._nodeViews.clear();
        this._nodeSubTrees.clear();
        this._upperTreePanel.setViewportView(null);
        this._viewPanel.setViewportView(null);
        this._lowerTreePanel.removeAll();
        this._lowerTreePanel.add((Component)this._emptyPanel, EMPTY_PANEL);
        ((CardLayout)this._lowerTreePanel.getLayout()).show(this._lowerTreePanel, EMPTY_PANEL);
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (!(e.getSource() instanceof ViewableJTree)) {
            return;
        }
        ViewableJTree currentTree = (ViewableJTree)e.getSource();
        ViewableJTreeNode currentNode = (ViewableJTreeNode)currentTree.getLastSelectedPathComponent();
        if (currentNode == null) {
            return;
        }
        if (currentTree == this._upperTree) {
            CardLayout cl = (CardLayout)this._lowerTreePanel.getLayout();
            JComponent nodeComponent = (JComponent)this._nodeSubTrees.get(currentNode);
            ViewableJTree[] subTrees = null;
            if (nodeComponent == null) {
                subTrees = currentNode.subTrees();
                if (subTrees != null) {
                    if (subTrees.length == 1) {
                        subTrees[0].setBackground(Deployer.TreeBackgroundColor);
                        subTrees[0].addTreeSelectionListener(this);
                        JScrollPane sPane = new JScrollPane();
                        sPane.getViewport().setBackground(Deployer.TreeBackgroundColor);
                        sPane.setViewportView(subTrees[0]);
                        nodeComponent = sPane;
                    } else {
                        JTabbedPane tabbedPane = new JTabbedPane(3, 1);
                        for (int i = 0; i < subTrees.length; ++i) {
                            subTrees[i].setBackground(Deployer.TreeBackgroundColor);
                            subTrees[i].addTreeSelectionListener(this);
                            JScrollPane sPane = new JScrollPane();
                            sPane.getViewport().setBackground(Deployer.TreeBackgroundColor);
                            sPane.setViewportView(subTrees[i]);
                            tabbedPane.insertTab(subTrees[i].getTreeName(), null, sPane, subTrees[i].getTreeDescription(), i);
                            tabbedPane.setBackgroundAt(i, Deployer.TreeBackgroundColor);
                        }
                        tabbedPane.setBorder(null);
                        tabbedPane.setFont(GuiUtil.getRegularFont());
                        nodeComponent = tabbedPane;
                    }
                    this._nodeSubTrees.put(currentNode, nodeComponent);
                    this._lowerTreePanel.add((Component)nodeComponent, this._upperTree.getSelectionPath().toString());
                } else {
                    this._currentTreeComponent = this._emptyPanel;
                    cl.show(this._lowerTreePanel, EMPTY_PANEL);
                }
            }
            if (nodeComponent != null && nodeComponent != this._currentTreeComponent) {
                cl = (CardLayout)this._lowerTreePanel.getLayout();
                cl.show(this._lowerTreePanel, this._upperTree.getSelectionPath().toString());
                if (this._currentTreeComponent == null) {
                    this._treePanel.resetToPreferredSizes();
                }
                this._currentTreeComponent = nodeComponent;
            }
            if (this._lastSelectedTree != this._upperTree) {
                this._lastSelectedTree.clearSelection();
                this._lastSelectedTree = this._upperTree;
            }
        } else if (this._lastSelectedTree == this._upperTree) {
            this._upperTree.clearSelection(true);
            this._lastSelectedTree = currentTree;
        }
        try {
            if (currentNode != null) {
                this._viewPanel.setViewportView(currentNode.viewComponent());
            }
        }
        catch (CreationException ce) {
            GuiUtil.errDialog("Error creating view for node " + currentNode);
            ce.printStackTrace();
            this._viewPanel.setViewportView(new JPanel());
        }
    }
}

